package org.accidia.echo.memcache;

import com.google.common.base.Strings;
import com.google.protobuf.Message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.google.common.base.Preconditions.checkArgument;

public class MemcacheAccessor {
    private static final Map<MemcacheDataSource, MemcacheAccessor> instanceMap = new ConcurrentHashMap<>();
    private final MemcacheDataSource memcacheDataSource;

    protected MemcacheAccessor(final MemcacheDataSource memcacheDataSource) {
        this.memcacheDataSource = memcacheDataSource;
    }

    public static synchronized MemcacheAccessor getInstance(final MemcacheDataSource memcacheDataSource) {
        checkArgument(memcacheDataSource != null, "null datasource");
        if (!instanceMap.containsKey(memcacheDataSource)) {
            final MemcacheAccessor instance = new MemcacheAccessor(memcacheDataSource);
            instanceMap.put(memcacheDataSource, instance);
        }
        return instanceMap.get(memcacheDataSource);
    }

    public Message get(final String key) {
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return (Message) this.memcacheDataSource.getMemcachedClient().get(key);
    }

    public void set(final String key, final int expiry, final Message value) {
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        checkArgument(value != null, "null value");
        this.memcacheDataSource.getMemcachedClient().set(key, expiry, value);
    }

    public void delete(final String key) {
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        this.memcacheDataSource.getMemcachedClient().delete(key);
    }
}

