/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.protoserver.misc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponses {
    public static final Logger logger = LoggerFactory.getLogger(AsyncResponses.class);

    public static void addTimeoutHandler(AsyncResponse asyncResponse, long timeout, TimeUnit timeUnit) {
        logger.debug("addTimeoutHandler(asyncResponse)");
        Preconditions.checkArgument(asyncResponse != null, "null asyncResponse");
        Preconditions.checkArgument(timeUnit != null, "null timeUnit");
        asyncResponse.setTimeoutHandler(new TimeoutHandler(){

            @Override
            public void handleTimeout(AsyncResponse asyncResponse) {
                asyncResponse.resume(Response.status(Response.Status.REQUEST_TIMEOUT).entity("operation timeout").build());
            }
        });
        asyncResponse.setTimeout(timeout, timeUnit);
    }

    public static void addCompletionCallback(AsyncResponse asyncResponse) {
        logger.debug("addCompletionCallback(asyncResponse)");
        Preconditions.checkArgument(asyncResponse != null, "null asyncResponse");
        asyncResponse.register(new CompletionCallback(){

            @Override
            public void onComplete(Throwable throwable) {
                if (throwable == null) {
                    logger.debug("completed");
                } else {
                    logger.warn("exception thrown: ", throwable);
                }
            }
        });
    }

    public static <ResponseType> void addCallbackForListenableFuture(final AsyncResponse asyncResponse, ListenableFuture<ResponseType> future) {
        logger.debug("addCallbackForListenableFuture(asyncResponse,future)");
        Preconditions.checkArgument(asyncResponse != null, "null asyncResponse");
        Preconditions.checkArgument(future != null, "null future");
        Futures.addCallback(future, new FutureCallback<ResponseType>(){

            @Override
            public void onSuccess(ResponseType response) {
                asyncResponse.resume(response);
            }

            @Override
            public void onFailure(Throwable throwable) {
                asyncResponse.resume(throwable);
            }
        });
    }
}

