/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.services.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.accidia.echo.EchoContext;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.services.IDataSourceService;

public class DataSourceService
implements IDataSourceService {
    private final Map<String, Protos.DataSource> defaultDataSources = new ConcurrentHashMap<String, Protos.DataSource>();
    private final Map<String, Protos.DataSource> registeredDataSources = new ConcurrentHashMap<String, Protos.DataSource>();

    public DataSourceService() {
        for (Protos.DataSource defaulDataSource : EchoContext.INSTANCE.getConfiguration().getDefaultDataSources()) {
            this.defaultDataSources.put(defaulDataSource.getName(), defaulDataSource);
        }
    }

    @Override
    public Protos.DataSource getDataSource(String datasourceName) {
        Protos.DataSource dataSource = this.defaultDataSources.get(datasourceName);
        if (dataSource != null) {
            return dataSource;
        }
        return null;
    }

    @Override
    public void register(Protos.DataSource dataSource) {
        this.registeredDataSources.put(dataSource.getName(), dataSource);
    }

    @Override
    public Collection<Protos.DataSource> getDefaultDataSources() {
        return this.defaultDataSources.values();
    }

    @Override
    public Collection<Protos.DataSource> getRegisteredDataSources() {
        return this.registeredDataSources.values();
    }
}

