/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ArrayRecord;

public class ResultSetRecord
extends ArrayRecord {
    protected transient ResultSet resultSet;
    protected transient ResultSetMetaData metaData;
    protected transient DatabaseAccessor accessor;
    protected transient DatabasePlatform platform;
    protected transient boolean optimizeData;
    protected transient AbstractSession session;

    protected ResultSetRecord() {
    }

    public ResultSetRecord(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, DatabaseAccessor accessor, AbstractSession session) {
        super(fields, fieldsArray, new Object[fieldsArray.length]);
        this.resultSet = resultSet;
        this.metaData = metaData;
        this.accessor = accessor;
        this.platform = accessor.getPlatform();
        this.optimizeData = this.platform.shouldOptimizeDataConversion();
        this.session = session;
    }

    public void loadAllValuesFromResultSet() {
        int index = 0;
        while (index < this.valuesArray.length) {
            DatabaseField field;
            if (this.valuesArray[index] == null && (field = this.fieldsArray[index]) != null) {
                this.valuesArray[index] = this.getValueFromResultSet(index, field);
            }
            ++index;
        }
        this.removeResultSet();
    }

    public void removeNonIndirectionValues() {
        if (this.fieldsArray != null) {
            int index = 0;
            while (index < this.fieldsArray.length) {
                DatabaseField field = this.fieldsArray[index];
                if (field != null && !field.keepInRow()) {
                    this.valuesArray[index] = null;
                }
                ++index;
            }
        }
    }

    public void removAllValue() {
        if (this.valuesArray != null) {
            int index = 0;
            while (index < this.valuesArray.length) {
                this.valuesArray[index] = null;
                ++index;
            }
        }
    }

    public boolean hasResultSet() {
        return this.resultSet != null;
    }

    protected Object getValue(int index, DatabaseField field) {
        Object value = this.valuesArray[index];
        if (value == null) {
            this.valuesArray[index] = value = this.getValueFromResultSet(index, field);
        } else {
            this.loadAllValuesFromResultSet();
        }
        return value;
    }

    protected Object getValueFromResultSet(int index, DatabaseField field) {
        return this.accessor.getObject(this.resultSet, field, this.metaData, index + 1, this.platform, this.optimizeData, this.session);
    }

    public void removeResultSet() {
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    @Override
    public void clear() {
        this.removeResultSet();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.clear();
    }

    @Override
    protected void checkValues() {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        super.checkValues();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        return super.containsValue(value);
    }

    @Override
    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.index;
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                if (this.resultSet != null) {
                    return this.getValue(index, field);
                }
                return this.valuesArray[index];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field2 = this.fieldsArray[fieldIndex];
                if (field2 == key || field2.equals(key)) {
                    if (index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    if (this.resultSet != null) {
                        return this.getValue(fieldIndex, field2);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return null;
        }
        return super.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.index;
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                if (this.resultSet != null) {
                    return this.getValue(index, field);
                }
                return this.valuesArray[index];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field2 = this.fieldsArray[fieldIndex];
                if (field2 == key || field2.equals(key)) {
                    if (index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    if (this.resultSet != null) {
                        return this.getValue(fieldIndex, field2);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return AbstractRecord.noEntry;
        }
        return super.get(key);
    }
}

