/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql.keyvalue;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.memcache.MemcacheAccessor;
import org.accidia.echo.memcache.MemcacheDataSource;
import org.accidia.echo.mysql.keyvalue.MySqlKeyValueProtobufDao;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheOnMySqlProtobufDao<T extends MySqlKeyValueProtobufDao>
implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(MemcacheOnMySqlProtobufDao.class);
    private final T mySqlKeyValueProtobufDao;
    private final MemcacheAccessor memcacheAccessor;

    public static <T extends MySqlKeyValueProtobufDao> MemcacheOnMySqlProtobufDao<T> newInstance(Protos.DataSource memcacheDataSource, T mySqlKeyValueProtobufDao) throws IOException, ReflectiveOperationException, Descriptors.DescriptorValidationException {
        return new MemcacheOnMySqlProtobufDao<T>(memcacheDataSource, mySqlKeyValueProtobufDao);
    }

    protected MemcacheOnMySqlProtobufDao(Protos.DataSource memcacheDataSource, T mySqlKeyValueProtobufDao) throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        this.mySqlKeyValueProtobufDao = mySqlKeyValueProtobufDao;
        this.memcacheAccessor = MemcacheAccessor.getInstance(MemcacheDataSource.getInstance(memcacheDataSource));
    }

    @Override
    public Message findByKey(String key, boolean includeArchive) {
        Message message = null;
        try {
            message = this.memcacheAccessor.get(key, 50L);
        }
        catch (RuntimeException e) {
            logger.warn("exception on memcache get for key: " + key, e);
        }
        if (message != null) {
            return message;
        }
        message = ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findByKey(key, includeArchive);
        if (message != null) {
            this.memcacheAccessor.set(key, -1, message);
        }
        return message;
    }

    @Override
    public Message findFieldsByKey(String key, List<String> fields, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findFieldsByKey(key, fields, includeArchive);
    }

    @Override
    public List<String> findList(String listKey, int start, int count) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findList(listKey, start, count);
    }

    @Override
    public List<String> findAllList(String listKey) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllList(listKey);
    }

    @Override
    public List<Message> findListObjects(String listKey, int start, int count, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findListObjects(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllListObjects(String listKey, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllListObjects(listKey, includeArchive);
    }

    @Override
    public List<Message> findOrderedListObjectsAscending(String listKey, int start, int count, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findOrderedListObjectsAscending(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllOrderedListObjectsAscending(String listKey, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllOrderedListObjectsAscending(listKey, includeArchive);
    }

    @Override
    public List<Message> findOrderedListObjectsDescending(String listKey, int start, int count, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findOrderedListObjectsDescending(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllOrderedListObjectsDescending(String listKey, boolean includeArchive) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllOrderedListObjectsDescending(listKey, includeArchive);
    }

    @Override
    public List<String> findOrderedListAscending(String listKey, int start, int count) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findOrderedListAscending(listKey, start, count);
    }

    @Override
    public List<String> findAllOrderedListAscending(String listKey) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllOrderedListAscending(listKey);
    }

    @Override
    public List<String> findOrderedListDescending(String listKey, int start, int conut) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findOrderedListDescending(listKey, start, conut);
    }

    @Override
    public List<String> findAllOrderedListDescending(String listKey) {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).findAllOrderedListDescending(listKey);
    }

    @Override
    public void store(String key, Message object) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).store(key, object);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void addToList(String listKey, String objectKey) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).addToList(listKey, objectKey);
    }

    @Override
    public void removeFromList(String listKey, String objectKey) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).removeFromList(listKey, objectKey);
    }

    @Override
    public void addToOrderedList(String listKey, String objectKey, long weight) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).addToOrderedList(listKey, objectKey, weight);
    }

    @Override
    public void storeOrUpdate(String key, Message object) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).storeOrUpdate(key, object);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void archive(String key) {
        ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).archive(key);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void unArchive(String key) {
    }

    @Override
    public Message getMessageDefaultInstance() {
        return ((MySqlKeyValueProtobufDao)this.mySqlKeyValueProtobufDao).getMessageDefaultInstance();
    }
}

