package org.accidia.echo.mysql.keyvalue;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.memcache.MemcacheAccessor;
import org.accidia.echo.memcache.MemcacheDataSource;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;

public class MemcacheOnMySqlProtobufDao<T extends MySqlKeyValueProtobufDao> implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(MemcacheOnMySqlProtobufDao.class);
    private final T mySqlKeyValueProtobufDao;
    private final MemcacheAccessor memcacheAccessor;

    public static <T extends MySqlKeyValueProtobufDao> MemcacheOnMySqlProtobufDao<T> newInstance(final Protos.DataSource memcacheDataSource,
                                                                                                 final T mySqlKeyValueProtobufDao)
            throws IOException, ReflectiveOperationException, Descriptors.DescriptorValidationException {
        return new MemcacheOnMySqlProtobufDao<>(memcacheDataSource, mySqlKeyValueProtobufDao);
    }

    protected MemcacheOnMySqlProtobufDao(final Protos.DataSource memcacheDataSource, final T mySqlKeyValueProtobufDao)
            throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        this.mySqlKeyValueProtobufDao = mySqlKeyValueProtobufDao;
        this.memcacheAccessor = MemcacheAccessor.getInstance(MemcacheDataSource.getInstance(memcacheDataSource));
    }

    @Override
    public Message findByKey(final String key, boolean includeArchive) {
        Message message = null;
        try {
            message = this.memcacheAccessor.get(key, 50); // timeout on 50 milliseconds
        } catch (RuntimeException e) {
            logger.warn("exception on memcache get for key: " + key, e);
        }
        if (message != null) {
            return message;
        }

        message = this.mySqlKeyValueProtobufDao.findByKey(key, includeArchive);
        if (message != null) {
            this.memcacheAccessor.set(key, -1, message);
        }
        return message;
    }

    @Override
    public Message findFieldsByKey(final String key, final List<String> fields, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findFieldsByKey(key, fields, includeArchive);
    }

    @Override
    public List<String> findList(final String listKey, int start, int count) {
        return this.mySqlKeyValueProtobufDao.findList(listKey, start, count);
    }

    @Override
    public List<String> findAllList(final String listKey) {
        return this.mySqlKeyValueProtobufDao.findAllList(listKey);
    }

    @Override
    public List<Message> findListObjects(final String listKey, int start, int count, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findListObjects(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllListObjects(final String listKey, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findAllListObjects(listKey, includeArchive);
    }

    @Override
    public List<Message> findOrderedListObjectsAscending(final String listKey, int start, int count, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findOrderedListObjectsAscending(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllOrderedListObjectsAscending(final String listKey, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findAllOrderedListObjectsAscending(listKey, includeArchive);
    }

    @Override
    public List<Message> findOrderedListObjectsDescending(final String listKey, int start, int count, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findOrderedListObjectsDescending(listKey, start, count, includeArchive);
    }

    @Override
    public List<Message> findAllOrderedListObjectsDescending(final String listKey, boolean includeArchive) {
        return this.mySqlKeyValueProtobufDao.findAllOrderedListObjectsDescending(listKey, includeArchive);
    }

    @Override
    public List<String> findOrderedListAscending(final String listKey, int start, int count) {
        return this.mySqlKeyValueProtobufDao.findOrderedListAscending(listKey, start, count);
    }

    @Override
    public List<String> findAllOrderedListAscending(final String listKey) {
        return this.mySqlKeyValueProtobufDao.findAllOrderedListAscending(listKey);
    }

    @Override
    public List<String> findOrderedListDescending(final String listKey, int start, int conut) {
        return this.mySqlKeyValueProtobufDao.findOrderedListDescending(listKey, start, conut);
    }

    @Override
    public List<String> findAllOrderedListDescending(final String listKey) {
        return this.mySqlKeyValueProtobufDao.findAllOrderedListDescending(listKey);
    }

    @Override
    public void store(final String key, final Message object) {
        this.mySqlKeyValueProtobufDao.store(key, object);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void addToList(final String listKey, final String objectKey) {
        this.mySqlKeyValueProtobufDao.addToList(listKey, objectKey);
    }

    @Override
    public void removeFromList(final String listKey, final String objectKey) {
        this.mySqlKeyValueProtobufDao.removeFromList(listKey, objectKey);
    }

    @Override
    public void addToOrderedList(final String listKey, final String objectKey, long weight) {
        this.mySqlKeyValueProtobufDao.addToOrderedList(listKey, objectKey, weight);
    }

    @Override
    public void storeOrUpdate(final String key, final Message object) {
        this.mySqlKeyValueProtobufDao.storeOrUpdate(key, object);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void archive(final String key) {
        this.mySqlKeyValueProtobufDao.archive(key);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public void unArchive(String key) {
        this.mySqlKeyValueProtobufDao.unArchive(key);
        this.memcacheAccessor.delete(key);
    }

    @Override
    public Message getMessageDefaultInstance() {
        return this.mySqlKeyValueProtobufDao.getMessageDefaultInstance();
    }
}

