package org.accidia.echo.services;

import com.google.protobuf.Descriptors;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.protos.Protos.*;

import java.io.IOException;
import java.util.List;

public interface ITenantService {

    void validateTenant(final String tenant);

    void registerTenant(final Tenant tenant)
            throws IOException, ReflectiveOperationException, Descriptors.DescriptorValidationException;

    Tenant getTenant(final String tenant);

    IProtobufDao getDaoForTenant(final String tenant);

    IObjectsService getObjectsServicesForTenant(final String tenant);

    List<Tenant> getAllTenants();

    boolean isRegistered(final String tenant);
}
