/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.List;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.redis.RedisAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisProtobufDao
implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(RedisProtobufDao.class);
    private final Message messageDefaultInstance;
    private final RedisAccessor redisAccessor = new RedisAccessor();

    public static RedisProtobufDao newInstance(Message messageDefaultInstance, Protos.DataSource dataSource) {
        return new RedisProtobufDao(messageDefaultInstance, dataSource);
    }

    protected RedisProtobufDao(Message messageDefaultInstance, Protos.DataSource dataSource) {
        this.messageDefaultInstance = messageDefaultInstance;
    }

    @Override
    public List<Message> getAll() {
        return null;
    }

    @Override
    public Message findByKey(String key) {
        logger.debug("findByKey(key)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doFindByKey(key);
    }

    @Override
    public Message findFieldsByKey(String key, List<String> fields) {
        logger.debug("findFieldsByKey(key,fields)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return null;
    }

    @Override
    public List<String> findList(String key, int start, int count) {
        logger.debug("findList(key,start,count,orderby)");
        return this.doFindList(key, start, count);
    }

    @Override
    public List<Message> findListObjects(String listKey, int start, int count) {
        return null;
    }

    @Override
    public void store(String key, Message object) {
        logger.debug("store(key,object)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(object != null, "null object");
        this.doStore(key, object);
    }

    @Override
    public void addToList(String listKey, String objectKey) {
    }

    @Override
    public void storeOrUpdate(String key, Message object) {
    }

    @Override
    public void archive(String key) {
    }

    @Override
    public Message getMessageDefaultInstance() {
        return this.messageDefaultInstance;
    }

    protected Message doFindByKey(String key) {
        return null;
    }

    protected List<String> doFindList(String key, int start, int count) {
        return null;
    }

    protected void doDelete(String key) {
    }

    protected void doStore(String key, Message object) {
    }

    protected void doStoreOrUpdate(String key, Message object) {
    }
}

