/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class InsertObjectQuery
extends WriteObjectQuery {
    public InsertObjectQuery() {
    }

    public InsertObjectQuery(Object objectToInsert) {
        this();
        this.setObject(objectToInsert);
    }

    public InsertObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    @Override
    public void executeCommit() throws DatabaseException {
        QueryRedirector localRedirector = this.getRedirectorForQuery();
        if (localRedirector != null) {
            this.redirectQuery(localRedirector, this, this.session, this.translationRow);
            return;
        }
        if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    @Override
    public void executeCommitWithChangeSet() throws DatabaseException {
        this.executeCommit();
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultInsertObjectQueryRedirector();
    }

    @Override
    protected void prepare() {
        super.prepare();
        if (this.name == null) {
            this.name = "insert" + this.descriptor.getJavaClass().getSimpleName();
        }
        this.getQueryMechanism().prepareInsertObject();
    }

    @Override
    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.descriptor.getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasInsertQuery()) {
            return queryManager.getInsertQuery();
        }
        return null;
    }

    @Override
    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        InsertObjectQuery customInsertQuery = (InsertObjectQuery)customQuery;
        customInsertQuery.setObject(this.getObject());
        customInsertQuery.setObjectChangeSet(this.getObjectChangeSet());
        customInsertQuery.setCascadePolicy(this.getCascadePolicy());
        customInsertQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customInsertQuery.setModifyRow(null);
    }

    @Override
    public boolean isInsertObjectQuery() {
        return true;
    }
}

