package org.accidia.echo.mysql.keyvalue;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.protos.Protos.DataSource;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.springframework.jdbc.core.RowMapper;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySqlKeyValueEncryptedProtobufDao extends MySqlKeyValueProtobufDao implements IProtobufDao {

    private final String secretKey;
    private final RowMapper<Message> rowMapper;

    private final StandardPBEByteEncryptor encryptor;

    protected MySqlKeyValueEncryptedProtobufDao(final Message messageDefaultInstance, final DataSource dataSource, final String secretKey)
            throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        super(messageDefaultInstance, dataSource);
        this.secretKey = secretKey;
        this.rowMapper  = (resultSet, rowNum) -> mapResultSet(resultSet, getMessageBuilder());
        this.encryptor = new StandardPBEByteEncryptor();
        this.encryptor.setAlgorithm("PBEWithMD5AndDES");
        this.encryptor.setPassword(this.secretKey);
    }

    public static MySqlKeyValueEncryptedProtobufDao newInstance(final Message messageDefaultInstancee,
                                                                final DataSource dataSource,
                                                                final String secretKey) {
        try {
            final MySqlKeyValueEncryptedProtobufDao instance = new MySqlKeyValueEncryptedProtobufDao(messageDefaultInstancee, dataSource, secretKey);
            instance.createTablesIfNotExist();
            return instance;
        } catch (Descriptors.DescriptorValidationException | ReflectiveOperationException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] messageToBytes(final Message message) {
        final byte[] plainBytes = message.toByteArray();
        if (plainBytes == null || plainBytes.length < 0) {
            return null;
        }
        return this.encryptor.encrypt(plainBytes);
    }

    @Override
    protected RowMapper<Message> getRowMapper() {
        return this.rowMapper;
    }

    protected Message mapResultSet(final ResultSet resultSet, final Message.Builder builder)
            throws SQLException {
        try {
            final byte[] encryptedBytes = resultSet.getBytes("VALUE");
            if (encryptedBytes != null && encryptedBytes.length > 0) {
                builder.mergeFrom(this.encryptor.decrypt(encryptedBytes));
            }
        } catch (final InvalidProtocolBufferException e) {
            throw new SQLException(e);
        }
        return builder.buildPartial();
    }

    @Override
    public long getObjectWeight(String listKey, String objectKey) {
        return 0;
    }
}

