/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.async;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class AsyncContextDelegateProviderImpl
implements AsyncContextDelegateProvider {
    @Override
    public final AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
        return new ExtensionImpl(request, response);
    }

    private static final class ExtensionImpl
    implements AsyncContextDelegate {
        private static final int NEVER_TIMEOUT_VALUE = -1;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AtomicReference<AsyncContext> asyncContextRef;
        private final AtomicBoolean completed;

        private ExtensionImpl(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.asyncContextRef = new AtomicReference();
            this.completed = new AtomicBoolean(false);
        }

        @Override
        public void suspend() throws IllegalStateException {
            if (!this.completed.get() && this.asyncContextRef.get() == null) {
                AsyncContext asyncContext = this.request.startAsync(this.request, this.response);
                asyncContext.setTimeout(-1L);
                this.asyncContextRef.set(asyncContext);
            }
        }

        @Override
        public void complete() {
            this.completed.set(true);
            AsyncContext asyncContext = this.asyncContextRef.getAndSet(null);
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }
}

