/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.CASResponse;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.CASOperationStatus;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.BaseOperationImpl;

public abstract class OperationImpl
extends BaseOperationImpl
implements Operation {
    protected static final byte REQ_MAGIC = -128;
    protected static final byte RES_MAGIC = -127;
    protected static final byte DUMMY_OPCODE = -1;
    protected static final int MIN_RECV_PACKET = 24;
    protected static final int SUCCESS = 0;
    protected static final int ERR_NOT_FOUND = 1;
    protected static final int ERR_EXISTS = 2;
    protected static final int ERR_2BIG = 3;
    protected static final int ERR_INVAL = 4;
    protected static final int ERR_NOT_STORED = 5;
    protected static final int ERR_DELTA_BADVAL = 6;
    protected static final int ERR_NOT_MY_VBUCKET = 7;
    protected static final int ERR_UNKNOWN_COMMAND = 129;
    protected static final int ERR_NO_MEM = 130;
    protected static final int ERR_NOT_SUPPORTED = 131;
    protected static final int ERR_INTERNAL = 132;
    protected static final int ERR_BUSY = 133;
    protected static final int ERR_TEMP_FAIL = 134;
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected static final OperationStatus STATUS_OK = new CASOperationStatus(true, "OK", CASResponse.OK, StatusCode.SUCCESS);
    private static final AtomicInteger SEQ_NUMBER = new AtomicInteger(0);
    private final byte cmd;
    protected short vbucket = 0;
    protected final int opaque;
    private final byte[] header = new byte[24];
    private int headerOffset = 0;
    private byte[] payload = null;
    private byte[] errorMsg = null;
    protected int keyLen;
    protected byte responseCmd;
    protected int errorCode;
    protected int responseOpaque;
    protected long responseCas;
    private int payloadOffset = 0;

    protected OperationImpl(byte c, int o, OperationCallback cb) {
        this.cmd = c;
        this.opaque = o;
        this.setCallback(cb);
    }

    protected void resetInput() {
        this.payload = null;
        this.payloadOffset = 0;
        this.headerOffset = 0;
    }

    @Override
    public void readFromBuffer(ByteBuffer buffer) throws IOException {
        if (this.headerOffset < 24) {
            this.readHeaderFromBuffer(buffer);
            if (this.headerOffset == 24) {
                this.parseHeaderFromBuffer();
            }
        }
        if (this.headerOffset >= 24 && this.payload == null) {
            this.finishedPayload(EMPTY_BYTES);
        } else if (this.payload != null) {
            this.readPayloadFromBuffer(buffer);
        } else {
            this.getLogger().debug("Only read %d of the %d needed to fill a header", this.headerOffset, 24);
        }
    }

    private void readHeaderFromBuffer(ByteBuffer buffer) {
        int toRead = 24 - this.headerOffset;
        int available = buffer.remaining();
        toRead = Math.min(toRead, available);
        this.getLogger().debug("Reading %d header bytes", toRead);
        buffer.get(this.header, this.headerOffset, toRead);
        this.headerOffset += toRead;
    }

    private void parseHeaderFromBuffer() {
        byte magic = this.header[0];
        assert (magic == -127) : "Invalid magic:  " + magic;
        this.responseCmd = this.header[1];
        assert (this.cmd == -1 || this.responseCmd == this.cmd) : "Unexpected response command value";
        this.keyLen = OperationImpl.decodeShort(this.header, 2);
        this.errorCode = OperationImpl.decodeShort(this.header, 6);
        int bytesToRead = OperationImpl.decodeInt(this.header, 8);
        this.payload = new byte[bytesToRead];
        this.responseOpaque = OperationImpl.decodeInt(this.header, 12);
        this.responseCas = OperationImpl.decodeLong(this.header, 16);
        assert (this.opaqueIsValid()) : "Opaque is not valid";
    }

    private void readPayloadFromBuffer(ByteBuffer buffer) throws IOException {
        int toRead = this.payload.length - this.payloadOffset;
        int available = buffer.remaining();
        toRead = Math.min(toRead, available);
        this.getLogger().debug("Reading %d payload bytes", toRead);
        buffer.get(this.payload, this.payloadOffset, toRead);
        this.payloadOffset += toRead;
        if (this.payloadOffset == this.payload.length) {
            this.finishedPayload(this.payload);
        }
    }

    protected void finishedPayload(byte[] pl) throws IOException {
        OperationStatus status = this.getStatusForErrorCode(this.errorCode, pl);
        if (status == null) {
            this.handleError(OperationErrorType.SERVER, new String(pl));
        } else if (this.errorCode == 0) {
            this.decodePayload(pl);
            this.transitionState(OperationState.COMPLETE);
        } else if (this.errorCode == 7 && !this.getState().equals((Object)OperationState.COMPLETE)) {
            this.transitionState(OperationState.RETRY);
        } else {
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) throws IOException {
        if (errCode == 0) {
            return STATUS_OK;
        }
        StatusCode statusCode = StatusCode.fromBinaryCode(errCode);
        this.errorMsg = (byte[])errPl.clone();
        switch (errCode) {
            case 1: {
                return new CASOperationStatus(false, new String(errPl), CASResponse.NOT_FOUND, statusCode);
            }
            case 2: {
                return new CASOperationStatus(false, new String(errPl), CASResponse.EXISTS, statusCode);
            }
            case 5: {
                return new CASOperationStatus(false, new String(errPl), CASResponse.NOT_FOUND, statusCode);
            }
            case 3: 
            case 132: {
                this.handleError(OperationErrorType.SERVER, new String(errPl));
            }
            case 4: 
            case 6: 
            case 7: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: {
                return new OperationStatus(false, new String(errPl), statusCode);
            }
        }
        return null;
    }

    protected void decodePayload(byte[] pl) {
        assert (pl.length == 0) : "Payload has bytes, but decode isn't overridden";
        this.getCallback().receivedStatus(STATUS_OK);
    }

    protected boolean opaqueIsValid() {
        if (this.responseOpaque != this.opaque) {
            this.getLogger().warn("Expected opaque:  %d, got opaque:  %d\n", this.responseOpaque, this.opaque);
        }
        return this.responseOpaque == this.opaque;
    }

    static int decodeShort(byte[] data, int i) {
        return (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
    }

    static int decodeByte(byte[] data, int i) {
        return data[i] & 0xFF;
    }

    static int decodeInt(byte[] data, int i) {
        return (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
    }

    static long decodeUnsignedInt(byte[] data, int i) {
        return (long)(data[i] & 0xFF) << 24 | (long)((data[i + 1] & 0xFF) << 16) | (long)((data[i + 2] & 0xFF) << 8) | (long)(data[i + 3] & 0xFF);
    }

    static long decodeLong(byte[] data, int i) {
        return ((long)data[i] & 0xFFL) << 56 | ((long)data[i + 1] & 0xFFL) << 48 | ((long)data[i + 2] & 0xFFL) << 40 | ((long)data[i + 3] & 0xFFL) << 32 | ((long)data[i + 4] & 0xFFL) << 24 | ((long)data[i + 5] & 0xFFL) << 16 | ((long)data[i + 6] & 0xFFL) << 8 | (long)data[i + 7] & 0xFFL;
    }

    protected void prepareBuffer(String key, long cas, byte[] val, Object ... extraHeaders) {
        int extraLen = 0;
        int extraHeadersLength = extraHeaders.length;
        if (extraHeadersLength > 0) {
            extraLen = this.calculateExtraLength(extraHeaders);
        }
        byte[] keyBytes = KeyUtil.getKeyBytes(key);
        int bufSize = 24 + keyBytes.length + val.length;
        ByteBuffer bb = ByteBuffer.allocate(bufSize + extraLen);
        assert (bb.order() == ByteOrder.BIG_ENDIAN);
        bb.put((byte)-128);
        bb.put(this.cmd);
        bb.putShort((short)keyBytes.length);
        bb.put((byte)extraLen);
        bb.put((byte)0);
        bb.putShort(this.vbucket);
        bb.putInt(keyBytes.length + val.length + extraLen);
        bb.putInt(this.opaque);
        bb.putLong(cas);
        if (extraHeadersLength > 0) {
            this.addExtraHeaders(bb, extraHeaders);
        }
        bb.put(keyBytes);
        bb.put(val);
        bb.flip();
        this.setBuffer(bb);
    }

    private void addExtraHeaders(ByteBuffer bb, Object ... extraHeaders) {
        for (Object o : extraHeaders) {
            if (o instanceof Integer) {
                bb.putInt((Integer)o);
                continue;
            }
            if (o instanceof byte[]) {
                bb.put((byte[])o);
                continue;
            }
            if (o instanceof Long) {
                bb.putLong((Long)o);
                continue;
            }
            if (o instanceof Short) {
                bb.putShort((Short)o);
                continue;
            }
            assert (false) : "Unhandled extra header type:  " + o.getClass();
        }
    }

    private int calculateExtraLength(Object ... extraHeaders) {
        int extraLen = 0;
        for (Object o : extraHeaders) {
            if (o instanceof Integer) {
                extraLen += 4;
                continue;
            }
            if (o instanceof byte[]) {
                extraLen += ((byte[])o).length;
                continue;
            }
            if (o instanceof Long) {
                extraLen += 8;
                continue;
            }
            if (o instanceof Short) {
                extraLen += 2;
                continue;
            }
            assert (false) : "Unhandled extra header type:  " + o.getClass();
        }
        return extraLen;
    }

    static int generateOpaque() {
        int rv = SEQ_NUMBER.incrementAndGet();
        while (rv < 0) {
            SEQ_NUMBER.compareAndSet(rv, 0);
            rv = SEQ_NUMBER.incrementAndGet();
        }
        return rv;
    }

    public String toString() {
        return "Cmd: " + this.cmd + " Opaque: " + this.opaque;
    }

    @Override
    public byte[] getErrorMsg() {
        return this.errorMsg;
    }
}

