/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.accidia.echo.EchoContext;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.mysql.keyvalue.MySqlKeyValueProtobufDao;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.services.IObjectsService;
import org.accidia.echo.services.ITenantService;
import org.accidia.echo.services.impl.DataSourceService;
import org.accidia.echo.services.impl.ObjectsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantService
implements ITenantService {
    private static final Logger logger = LoggerFactory.getLogger(TenantService.class);
    private final DataSourceService dataSourceService;
    private final Map<String, Protos.Tenant> tenantNameToTenantMap = new ConcurrentHashMap<String, Protos.Tenant>();
    private final Map<String, IProtobufDao> tenantNameToProtobufDao = new ConcurrentHashMap<String, IProtobufDao>();
    private final Map<String, IObjectsService> tenantToObjectsServicesMap = new ConcurrentHashMap<String, IObjectsService>();
    private List<Protos.Tenant> allTenants = new ArrayList<Protos.Tenant>();

    @Inject
    public TenantService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    @Override
    public void validateTenant(String tenant) throws IllegalArgumentException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tenant.trim()), "null/empty tenant name");
    }

    @Override
    public void registerTenant(Protos.Tenant tenant) throws IOException, ReflectiveOperationException, Descriptors.DescriptorValidationException {
        logger.debug("registerTenant(tenantMeta)");
        Preconditions.checkArgument(tenant != null, "null tenant");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tenant.getName()), "null/empty tenant name");
        this.doRegisterTenant(tenant);
    }

    @Override
    public Protos.Tenant getTenant(String tenant) {
        logger.debug("getTenant(tenant)");
        this.validateTenant(tenant);
        return Preconditions.checkNotNull(this.tenantNameToTenantMap.get(tenant), "tenant is not registered: " + tenant);
    }

    @Override
    public IProtobufDao getDaoForTenant(String tenant) {
        logger.debug("getDaoForTenant(tenant)");
        this.validateTenant(tenant);
        return this.tenantNameToProtobufDao.get(tenant);
    }

    @Override
    public IObjectsService getObjectsServicesForTenant(String tenant) {
        logger.debug("getObjectsServicesForTenant(tenant)");
        this.validateTenant(tenant);
        return this.tenantToObjectsServicesMap.get(tenant);
    }

    @Override
    public List<Protos.Tenant> getAllTenants() {
        logger.debug("getAllTenants()");
        return this.allTenants;
    }

    protected void doRegisterTenant(Protos.Tenant tenant) throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        MySqlKeyValueProtobufDao protobufDao;
        Protos.DataSource dataSource = this.dataSourceService.getDataSource(tenant.getDatasourceName());
        Preconditions.checkArgument(dataSource != null, "invalid datasource");
        this.tenantNameToTenantMap.put(tenant.getName(), tenant);
        this.allTenants.add(tenant);
        switch (dataSource.getStorageType()) {
            case MYSQL_KEYVALUE: {
                protobufDao = MySqlKeyValueProtobufDao.newInstance(tenant, dataSource);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ObjectsService objectsServices = new ObjectsService(EchoContext.INSTANCE.getExecutorService(), protobufDao);
        this.tenantToObjectsServicesMap.put(tenant.getName(), objectsServices);
        this.tenantNameToProtobufDao.put(tenant.getName(), protobufDao);
    }

    @Override
    public boolean isRegistered(String tenant) {
        return false;
    }
}

