/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.dao;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import java.util.List;
import org.accidia.echo.EchoContext;
import org.accidia.echo.dao.StorageInitFailed;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(AbstractStorageModule.class);

    public abstract void configureForDataSource(Protos.DataSource var1) throws StorageInitFailed;

    @Override
    protected final void configure() {
        this.logger.debug("configure()");
        Preconditions.checkArgument(EchoContext.INSTANCE.getConfiguration() != null, "null configuration");
        List<Protos.DataSource> defaultDataSources = EchoContext.INSTANCE.getConfiguration().getDefaultDataSources();
        Preconditions.checkArgument(defaultDataSources != null && !defaultDataSources.isEmpty(), "null/empty list of storage meta");
        for (Protos.DataSource dataSource : defaultDataSources) {
            this.logger.info("trying to configure for store with name {}", (Object)dataSource.getName());
            try {
                if (this.getStorageType() == dataSource.getStorageType()) {
                    this.logger.info("configuring store with name {}", (Object)dataSource.getName());
                    this.configureForDataSource(dataSource);
                    continue;
                }
                this.logger.info("module {} is not responsible for the store with name {}", (Object)this.getClass().getName(), (Object)dataSource.getName());
            }
            catch (StorageInitFailed e) {
                this.logger.error("configuring storage failed: ", e);
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract Protos.DataSource.StorageType getStorageType();
}

