/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.memcache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.internal.GetFuture;
import org.accidia.echo.memcache.IMemcacheAccessor;
import org.accidia.echo.memcache.MemcacheDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheAccessor
implements IMemcacheAccessor {
    private static final Logger logger = LoggerFactory.getLogger(MemcacheAccessor.class);
    private static final Map<MemcacheDataSource, MemcacheAccessor> instanceMap = new ConcurrentHashMap<MemcacheDataSource, MemcacheAccessor>();
    private final MemcacheDataSource memcacheDataSource;

    protected MemcacheAccessor(MemcacheDataSource memcacheDataSource) {
        this.memcacheDataSource = memcacheDataSource;
    }

    public static synchronized MemcacheAccessor getInstance(MemcacheDataSource memcacheDataSource) {
        Preconditions.checkArgument(memcacheDataSource != null, "null datasource");
        if (!instanceMap.containsKey(memcacheDataSource)) {
            MemcacheAccessor instance = new MemcacheAccessor(memcacheDataSource);
            instanceMap.put(memcacheDataSource, instance);
        }
        return instanceMap.get(memcacheDataSource);
    }

    @Override
    public Message get(String key, long timeoutMs) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Future futureGet = this.memcacheDataSource.getMemcachedClient().asyncGet(key);
        try {
            return (Message)((GetFuture)futureGet).get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("exception on async get -> ignoring and returning null ", e);
            ((GetFuture)futureGet).cancel(false);
            return null;
        }
    }

    @Override
    public void set(String key, int expiry, Object value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(value != null, "null value");
        this.memcacheDataSource.getMemcachedClient().set(key, expiry, value);
    }

    @Override
    public void delete(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        this.memcacheDataSource.getMemcachedClient().delete(key);
    }
}

