package org.accidia.echo.mysql.keyvalue;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.ResultSet;
import java.sql.SQLException;

public class MySqlKeyValueProtobufRowMapper {
    private static final Logger logger = LoggerFactory.getLogger(MySqlKeyValueProtobufRowMapper.class);

    public Message mapResultSet(final ResultSet resultSet, final Message.Builder builder)
            throws SQLException {
        logger.debug("mapRow(resultSet,rowNum)");
        try {
            builder.mergeFrom(resultSet.getBytes("VALUE"));
        } catch (final InvalidProtocolBufferException e) {
            logger.error("invalid protobuf", e);
            throw new SQLException(e);
        }
        return builder.buildPartial();
    }
}
