/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;

public class CouchDBFormat
extends JsonFormat {
    public static void print(Message message, Appendable output) throws IOException {
        CouchDBGenerator generator = new CouchDBGenerator(output);
        generator.print("{");
        CouchDBFormat.print(message, generator);
        generator.print("}");
    }

    public static void print(UnknownFieldSet fields, Appendable output) throws IOException {
        CouchDBGenerator generator = new CouchDBGenerator(output);
        generator.print("{");
        CouchDBFormat.printUnknownFields(fields, generator);
        generator.print("}");
    }

    public static String printToString(Message message) {
        try {
            StringBuilder text = new StringBuilder();
            CouchDBFormat.print(message, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public static String printToString(UnknownFieldSet fields) {
        try {
            StringBuilder text = new StringBuilder();
            CouchDBFormat.print(fields, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        CouchDBFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws JsonFormat.ParseException {
        CouchDBFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        CouchDBFormat.merge(JsonFormat.toStringBuilder(input), extensionRegistry, builder);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws JsonFormat.ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        tokenizer.consume("{");
        while (!tokenizer.tryConsume("}")) {
            JsonFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    protected static class CouchDBGenerator
    extends JsonFormat.JsonGenerator {
        public CouchDBGenerator(Appendable output) {
            super(output);
        }

        @Override
        public void print(CharSequence text) throws IOException {
            if ("id".equals(text)) {
                super.print("_id");
            } else if ("rev".equals(text)) {
                super.print("_rev");
            } else {
                super.print(text);
            }
        }
    }

    protected static class Tokenizer
    extends JsonFormat.Tokenizer {
        public Tokenizer(CharSequence text) {
            super(text);
        }

        @Override
        public String consumeIdentifier() throws JsonFormat.ParseException {
            String id = super.consumeIdentifier();
            if ("_id".equals(id)) {
                return "id";
            }
            if ("_rev".equals(id)) {
                return "rev";
            }
            return id;
        }
    }
}

