/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.jrz.providers;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageListWriter
implements MessageBodyWriter<List<? extends Message>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(List<? extends Message> messages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<? extends Message> messages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        StringBuffer buffer = new StringBuffer();
        if (messages != null && !messages.isEmpty()) {
            for (Message message : messages) {
                JsonFormat.print((Message)message, (Appendable)buffer);
            }
        }
        outputStream.write(buffer.toString().getBytes());
    }
}

