/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.jrz.providers;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/x-protobuf"})
public class ProtobufMessageReader<ProtobufType extends Message>
implements MessageBodyReader<ProtobufType> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Message.class.isAssignableFrom(type);
    }

    public ProtobufType readFrom(Class<ProtobufType> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException, WebApplicationException {
        try {
            Method newBuilder = type.getMethod("newBuilder", new Class[0]);
            GeneratedMessage.Builder builder = (GeneratedMessage.Builder)newBuilder.invoke(type, new Object[0]);
            return (ProtobufType)builder.mergeFrom(inputStream).buildPartial();
        }
        catch (Exception e) {
            this.logger.error("exception caught on protobuf message body reader -> rethrowing ", (Throwable)e);
            throw new WebApplicationException("exception caught on protobuf message body reader", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

