/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver.providers;

import com.google.common.base.Charsets;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class JsonMessageMapWriter
implements MessageBodyWriter<Map<String, Message>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(Map<String, Message> map, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.mapToString(map).length();
    }

    public void writeTo(Map<String, Message> map, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        outputStream.write(this.mapToString(map).getBytes(Charsets.UTF_8));
    }

    protected String mapToString(Map<String, Message> map) {
        StringBuilder builder = new StringBuilder("{");
        String comma = "";
        for (Map.Entry<String, Message> entry : map.entrySet()) {
            builder.append(comma);
            builder.append("\"").append(entry.getKey()).append("\": ").append(JsonFormat.printToString((Message)entry.getValue()));
            comma = ",";
        }
        builder.append("}");
        return builder.toString();
    }
}

