package org.accidia.protoserver;

import org.accidia.protoserver.misc.ProtoServerException;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.server.ResourceConfig;

import java.net.URI;

/**
 * <p>IProtoServerApplication interface.</p>
 *
 * @author peymant
 * @version $Id: $Id
 */
public interface IProtoServerApplication {

    /**
     * <p>startServer.</p>
     *
     * @throws org.accidia.protoserver.misc.ProtoServerException if any.
     */
    void startServer() throws ProtoServerException;

    /**
     * <p>joinOnServer.</p>
     *
     * @throws org.accidia.protoserver.misc.ProtoServerException if any.
     */
    void joinOnServer() throws ProtoServerException;

    /**
     * <p>stopServer.</p>
     *
     * @throws org.accidia.protoserver.misc.ProtoServerException if any.
     */
    void stopServer() throws ProtoServerException;

    /**
     * <p>getServer.</p>
     *
     * @return a {@link org.eclipse.jetty.server.Server} object.
     * @throws org.accidia.protoserver.misc.ProtoServerException if any.
     */
    Server getServer() throws ProtoServerException;

    /**
     * <p>getResourceConfig.</p>
     *
     * @return a {@link org.glassfish.jersey.server.ResourceConfig} object.
     */
    ResourceConfig getResourceConfig();

    /**
     * <p>getBaseUri.</p>
     *
     * @return a {@link java.net.URI} object.
     */
    URI getBaseUri();
}
