/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core;

import org.achtern.AchternEngine.core.CoreEngine;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.RenderPass;
import org.achtern.AchternEngine.core.rendering.mesh.Quad;
import org.achtern.AchternEngine.core.rendering.shader.BasicShader;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Camera;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingScreen
implements RenderPass {
    public static final String DEFAULT_TEXTURE_NAME = "loading.v0.0.1.png";
    public static final Logger LOGGER = LoggerFactory.getLogger(LoadingScreen.class);
    private static LoadingScreen instance;

    public static LoadingScreen get() {
        if (instance == null) {
            instance = new LoadingScreen();
        }
        return instance;
    }

    public void preLoad() {
        try {
            ResourceLoader.getTexture(DEFAULT_TEXTURE_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Error Loading bundled LoadingScreen image.");
        }
    }

    public void show(CoreEngine engine) {
        try {
            this.show(engine, ResourceLoader.getTexture(DEFAULT_TEXTURE_NAME));
        }
        catch (Exception e) {
            LOGGER.error("Error Loading bundled LoadingScreen image.");
        }
    }

    public void show(CoreEngine engine, Texture loadingImage) {
        if (loadingImage == null) {
            this.show(engine);
            return;
        }
        Material material = new Material();
        material.addTexture("diffuse", loadingImage);
        material.setColor(Color.WHITE);
        Figure figure = new Figure(new Quad(2, 2), material);
        Node holder = new Node("LoadingScreen");
        holder.setEngine(engine);
        Node quad = new Node("Image").add(figure);
        quad.setEngine(engine);
        quad.getTransform().getPosition().subLocal(new Vector3f(1.0f, 1.0f, 0.0f));
        holder.add(new Node("Camera").add(new Camera(new Matrix4f().initIdentiy())));
        holder.add(quad);
        holder.update(0.0f);
        engine.getRenderEngine().addRenderPass(this);
        engine.getRenderEngine().render(holder);
        engine.getWindow().render();
        engine.getRenderEngine().removeRenderPass(this);
        engine.getRenderEngine().setCamera(null);
    }

    public Shader getShader() {
        return BasicShader.getInstance();
    }
}

