/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.input.event.payload;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.input.MouseButton;
import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.input.event.payload.InputEvent;
import org.achtern.AchternEngine.core.math.Vector2f;

public class MouseEvent
implements InputEvent {
    protected final InputAdapter inputAdapter;
    protected final MouseButton button;
    protected final float delta;
    protected final Vector2f position;
    protected final Vector2f mouseDelta;

    @ConstructorProperties(value={"inputAdapter", "button", "delta", "position", "mouseDelta"})
    public MouseEvent(InputAdapter inputAdapter, MouseButton button, float delta, Vector2f position, Vector2f mouseDelta) {
        this.inputAdapter = inputAdapter;
        this.button = button;
        this.delta = delta;
        this.position = position;
        this.mouseDelta = mouseDelta;
    }

    public InputAdapter getInputAdapter() {
        return this.inputAdapter;
    }

    public MouseButton getButton() {
        return this.button;
    }

    public float getDelta() {
        return this.delta;
    }

    public Vector2f getPosition() {
        return this.position;
    }

    public Vector2f getMouseDelta() {
        return this.mouseDelta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MouseEvent)) {
            return false;
        }
        MouseEvent other = (MouseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputAdapter this$inputAdapter = this.getInputAdapter();
        InputAdapter other$inputAdapter = other.getInputAdapter();
        if (this$inputAdapter == null ? other$inputAdapter != null : !this$inputAdapter.equals(other$inputAdapter)) {
            return false;
        }
        MouseButton this$button = this.getButton();
        MouseButton other$button = other.getButton();
        if (this$button == null ? other$button != null : !((Object)((Object)this$button)).equals((Object)other$button)) {
            return false;
        }
        if (Float.compare(this.getDelta(), other.getDelta()) != 0) {
            return false;
        }
        Vector2f this$position = this.getPosition();
        Vector2f other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Vector2f this$mouseDelta = this.getMouseDelta();
        Vector2f other$mouseDelta = other.getMouseDelta();
        return !(this$mouseDelta == null ? other$mouseDelta != null : !((Object)this$mouseDelta).equals(other$mouseDelta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MouseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputAdapter $inputAdapter = this.getInputAdapter();
        result = result * 59 + ($inputAdapter == null ? 0 : $inputAdapter.hashCode());
        MouseButton $button = this.getButton();
        result = result * 59 + ($button == null ? 0 : ((Object)((Object)$button)).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getDelta());
        Vector2f $position = this.getPosition();
        result = result * 59 + ($position == null ? 0 : ((Object)$position).hashCode());
        Vector2f $mouseDelta = this.getMouseDelta();
        result = result * 59 + ($mouseDelta == null ? 0 : ((Object)$mouseDelta).hashCode());
        return result;
    }

    public String toString() {
        return "MouseEvent(inputAdapter=" + this.getInputAdapter() + ", button=" + (Object)((Object)this.getButton()) + ", delta=" + this.getDelta() + ", position=" + this.getPosition() + ", mouseDelta=" + this.getMouseDelta() + ")";
    }
}

