/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.input.inputmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.input.inputmap.InputMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMap
implements InputMap<KeyTrigger, KeyListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyMap.class);
    protected InputAdapter input;
    protected Map<KeyTrigger, List<KeyListener>> listener = new HashMap<KeyTrigger, List<KeyListener>>();
    protected Map<KeyTrigger, List<KeyListener>> delayed = new HashMap<KeyTrigger, List<KeyListener>>();
    protected boolean cycle = false;

    public KeyMap(InputAdapter input) {
        this();
        this.input = input;
    }

    public KeyMap() {
    }

    public KeyMap register(KeyTrigger key, KeyListener h) {
        if (this.cycle) {
            if (!this.delayed.containsKey(key)) {
                this.delayed.put(key, new ArrayList());
            }
            this.delayed.get(key).add(h);
            return this;
        }
        if (!this.listener.containsKey(key)) {
            this.listener.put(key, new ArrayList());
        }
        this.listener.get(key).add(h);
        return this;
    }

    public KeyMap register(List<KeyTrigger> keys, KeyListener h) {
        for (KeyTrigger t : keys) {
            this.register(t, h);
        }
        return this;
    }

    @Override
    public void trigger(float delta) {
        Set<KeyTrigger> keys = this.listener.keySet();
        this.cycle = true;
        for (KeyTrigger k : keys) {
            if (this.input.getKey(k.get()) && k.getType().equals((Object)KeyTrigger.Type.PRESS)) {
                this.cycle(k, delta);
            }
            if (this.input.getKeyDown(k.get()) && k.getType().equals((Object)KeyTrigger.Type.DOWN)) {
                this.cycle(k, delta);
            }
            if (!this.input.getKeyUp(k.get()) || !k.getType().equals((Object)KeyTrigger.Type.UP)) continue;
            this.cycle(k, delta);
        }
        this.cycle = false;
        if (!this.delayed.isEmpty()) {
            this.listener.putAll(this.delayed);
            this.delayed.clear();
            assert (this.delayed.size() == 0);
        }
    }

    protected void cycle(KeyTrigger k, float delta) {
        for (KeyListener l : this.listener.get(k)) {
            l.onAction(new KeyEvent(this.input, k.get(), delta));
        }
    }

    @Override
    public Map<KeyTrigger, List<KeyListener>> getClickListener() {
        return this.listener;
    }

    @Override
    public void setClickListener(Map<KeyTrigger, List<KeyListener>> listener) {
        this.listener = listener;
    }

    @Override
    public InputAdapter getInput() {
        return this.input;
    }

    @Override
    public void setInput(InputAdapter input) {
        this.input = input;
    }
}

