/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.input.inputmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.input.event.listener.MouseListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.MouseButtonTrigger;
import org.achtern.AchternEngine.core.input.event.payload.MouseEvent;
import org.achtern.AchternEngine.core.input.inputmap.InputMap;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseMap
implements InputMap<MouseButtonTrigger, MouseListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MouseMap.class);
    protected InputAdapter input;
    protected Map<MouseButtonTrigger, List<MouseListener>> clickListener;
    protected List<MouseListener> moveListener;
    protected Vector2f previousPosition = new Vector2f(0.0f, 0.0f);

    public MouseMap() {
        this.clickListener = new HashMap<MouseButtonTrigger, List<MouseListener>>();
        this.moveListener = new ArrayList<MouseListener>();
    }

    public MouseMap(InputAdapter input) {
        this();
        this.input = input;
    }

    public MouseMap register(MouseButtonTrigger button, MouseListener l) {
        if (!this.clickListener.containsKey(button)) {
            this.clickListener.put(button, new ArrayList());
        }
        this.clickListener.get(button).add(l);
        return this;
    }

    public MouseMap register(List<MouseButtonTrigger> buttons, MouseListener h) {
        for (MouseButtonTrigger t : buttons) {
            this.register(t, h);
        }
        return this;
    }

    public MouseMap register(MouseListener l) {
        this.moveListener.add(l);
        return this;
    }

    @Override
    public void trigger(float delta) {
        Set<MouseButtonTrigger> keys = this.clickListener.keySet();
        for (MouseButtonTrigger b : keys) {
            if (this.input.getMouse(b.get()) && b.getType().equals((Object)MouseButtonTrigger.Type.PRESS)) {
                this.cycle(b, delta);
            }
            if (this.input.getMouseDown(b.get()) && b.getType().equals((Object)MouseButtonTrigger.Type.DOWN)) {
                this.cycle(b, delta);
            }
            if (!this.input.getMouseUp(b.get()) || !b.getType().equals((Object)MouseButtonTrigger.Type.UP)) continue;
            this.cycle(b, delta);
        }
        Vector2f position = this.input.getMousePosition();
        if (position.equals(this.previousPosition)) {
            return;
        }
        for (MouseListener l : this.moveListener) {
            l.onAction(new MouseEvent(this.input, null, delta, position, position.sub(this.previousPosition)));
        }
        this.previousPosition = this.input.getMousePosition();
    }

    protected void cycle(MouseButtonTrigger b, float delta) {
        for (MouseListener l : this.clickListener.get(b)) {
            l.onAction(new MouseEvent(this.input, b.get(), delta, this.input.getMousePosition(), null));
        }
    }

    @Override
    public Map<MouseButtonTrigger, List<MouseListener>> getClickListener() {
        return this.clickListener;
    }

    @Override
    public InputAdapter getInput() {
        return this.input;
    }

    @Override
    public void setInput(InputAdapter input) {
        this.input = input;
    }

    @Override
    public void setClickListener(Map<MouseButtonTrigger, List<MouseListener>> clickListener) {
        this.clickListener = clickListener;
    }
}

