/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.math;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.rendering.Dimension;

public class Vector2f {
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2f UNIT_X = new Vector2f(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = new Vector2f(0.0f, 1.0f);
    public static final Vector2f ONE = new Vector2f(1.0f, 1.0f);
    private float x;
    private float y;

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float dot(Vector2f v) {
        return this.x * v.getX() + this.y * v.getY();
    }

    public float cross(Vector2f v) {
        return this.x * v.getY() + this.y * v.getX();
    }

    public Vector2f normalized() {
        float l = this.length();
        return new Vector2f(this.x / l, this.y / l);
    }

    public Vector2f normalize() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        return this;
    }

    public Vector2f lerp(Vector2f dest, float factor) {
        return dest.sub(this).mul(factor).add(this);
    }

    public Vector2f rotate(float angle) {
        double rad = Math.toRadians(angle);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new Vector2f((float)((double)this.x * cos - (double)this.y * sin), (float)((double)this.x * sin + (double)this.y * cos));
    }

    public float max() {
        return Math.max(this.getX(), this.getY());
    }

    public Vector2f add(Vector2f v) {
        return new Vector2f(this.x + v.getX(), this.y + v.getY());
    }

    public Vector2f add(float v) {
        return new Vector2f(this.x + v, this.y + v);
    }

    public Vector2f sub(Vector2f v) {
        return new Vector2f(this.x - v.getX(), this.y - v.getY());
    }

    public Vector2f sub(float v) {
        return new Vector2f(this.x - v, this.y - v);
    }

    public Vector2f mul(Vector2f v) {
        return new Vector2f(this.x * v.getX(), this.y * v.getY());
    }

    public Vector2f mul(float v) {
        return new Vector2f(this.x * v, this.y * v);
    }

    public Vector2f div(Vector2f v) {
        return new Vector2f(this.x / v.getX(), this.y / v.getY());
    }

    public Vector2f div(float v) {
        return new Vector2f(this.x / v, this.y / v);
    }

    public Vector2f abs() {
        return new Vector2f(Math.abs(this.x), Math.abs(this.y));
    }

    public void set(Vector2f v) {
        this.setX(v.getX());
        this.setY(v.getY());
    }

    public void set(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public boolean isNullVector() {
        return this.getX() == 0.0f && this.getY() == 0.0f;
    }

    public Dimension toDimension() {
        return new Dimension((int)this.getX(), (int)this.getY());
    }

    @ConstructorProperties(value={"x", "y"})
    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector2f)) {
            return false;
        }
        Vector2f other = (Vector2f)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Float.compare(this.getY(), other.getY()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector2f;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        return result;
    }

    public String toString() {
        return "Vector2f(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

