/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import java.awt.image.BufferedImage;
import org.achtern.AchternEngine.core.math.Vector2f;

public class Dimension
extends Vector2f {
    public static Dimension fromBufferedImage(BufferedImage image) {
        return new Dimension(image.getWidth(), image.getHeight());
    }

    public Dimension(Dimension copy) {
        this(copy.getWidth(), copy.getHeight());
    }

    public Dimension(int width, int height) {
        super(width, height);
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Not valid dimension, width|height MUST be greater than 0");
        }
    }

    public Dimension factor2() {
        int w;
        int h = 2;
        for (w = 2; w < this.getWidth(); w *= 2) {
        }
        while (h < this.getHeight()) {
            h *= 2;
        }
        return new Dimension(w, h);
    }

    public void setHeight(int height) {
        super.setY(height);
    }

    public void setWidth(int width) {
        super.setX(width);
    }

    public int getHeight() {
        return (int)this.getY();
    }

    public int getWidth() {
        return (int)this.getX();
    }
}

