/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.fog;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.rendering.Color;

public class Fog {
    public static final Fog DISABLED = new Fog(null, 0.0f, Mode.DISABLED);
    protected Color color;
    protected Vector2f range;
    protected float density;
    protected Mode mode;

    public Fog(Color color, float density) {
        this(color, density, Mode.EXP);
    }

    public Fog(Color color, float density, Mode mode) {
        this(color, new Vector2f(-1.0f, -1.0f), density, mode);
    }

    public Fog(Color color, Vector2f range) {
        this(color, range, -1.0f, Mode.LINEAR);
    }

    @ConstructorProperties(value={"color", "range", "density", "mode"})
    public Fog(Color color, Vector2f range, float density, Mode mode) {
        this.color = color;
        this.range = range;
        this.density = density;
        this.mode = mode;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector2f getRange() {
        return this.range;
    }

    public float getDensity() {
        return this.density;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRange(Vector2f range) {
        this.range = range;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fog)) {
            return false;
        }
        Fog other = (Fog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        Vector2f this$range = this.getRange();
        Vector2f other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        if (Float.compare(this.getDensity(), other.getDensity()) != 0) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Fog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 0 : ((Object)$color).hashCode());
        Vector2f $range = this.getRange();
        result = result * 59 + ($range == null ? 0 : ((Object)$range).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getDensity());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 0 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public String toString() {
        return "Fog(color=" + this.getColor() + ", range=" + this.getRange() + ", density=" + this.getDensity() + ", mode=" + (Object)((Object)this.getMode()) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        DISABLED(-1),
        LINEAR(0),
        EXP(1),
        EXP2(2);

        private int mode;

        private Mode(int mode) {
            this.mode = mode;
        }

        public int getID() {
            return this.mode;
        }
    }
}

