/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.generator;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.texture.ByteImage;
import org.achtern.AchternEngine.core.rendering.texture.TexturableData;
import org.achtern.AchternEngine.core.util.UBuffer;

public class ImageGenerator {
    public static BufferedImage fromColor(Color color) {
        return ImageGenerator.fromColor(new Vector2f(1.0f, 1.0f), color);
    }

    public static BufferedImage fromColor(Vector2f dimensions, Color color) {
        BufferedImage image = new BufferedImage((int)dimensions.getX(), (int)dimensions.getY(), 1);
        Graphics2D g = image.createGraphics();
        g.setPaint(color.toAwt());
        g.fillRect(0, 0, (int)dimensions.getX(), (int)dimensions.getY());
        g.dispose();
        return image;
    }

    public static TexturableData bytesFromColor(Color color) {
        return ImageGenerator.bytesFromColor(new Dimension(1, 1), color);
    }

    public static TexturableData bytesFromColor(Dimension dimension, Color color) {
        ByteBuffer buffer = UBuffer.createByteBuffer((int)(dimension.getX() * dimension.getY() * 4.0f));
        int y = 0;
        while ((float)y < dimension.getY()) {
            int x = 0;
            while ((float)x < dimension.getX()) {
                buffer.put((byte)(color.getRed() * 255.0f));
                buffer.put((byte)(color.getGreen() * 255.0f));
                buffer.put((byte)(color.getBlue() * 255.0f));
                buffer.put((byte)(color.getAlpha() * 255.0f));
                ++x;
            }
            ++y;
        }
        buffer.flip();
        return new ByteImage(buffer, true, dimension);
    }
}

