/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.mesh;

import java.util.ArrayList;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.util.UInteger;

public class Grid
extends Mesh {
    public Grid(int xCount, int yCount) {
        this(xCount, yCount, 1.0f);
    }

    public Grid(int xCount, int yCount, float lineSeparation) {
        this.generate(xCount, yCount, lineSeparation);
    }

    public void generate(int xCount, int yCount, float lineSeparation) {
        Vector3f v2;
        Vector3f v1;
        int i;
        int lineCount = xCount + yCount;
        ArrayList<Vector3f> positions = new ArrayList<Vector3f>(lineCount * 2);
        ArrayList<Integer> integers = new ArrayList<Integer>(lineCount);
        Vector2f length = new Vector2f(yCount - 1, xCount - 1).mul(lineSeparation);
        for (i = 0; i < xCount; ++i) {
            float y = (float)i * lineSeparation;
            v1 = new Vector3f(0.0f, 0.0f, y);
            v2 = new Vector3f(length.getX(), 0.0f, y);
            if (!positions.contains(v1)) {
                positions.add(v1);
            }
            if (!positions.contains(v2)) {
                positions.add(v2);
            }
            integers.add(positions.indexOf(v1));
            integers.add(positions.indexOf(v2));
        }
        for (i = 0; i < yCount; ++i) {
            float x = (float)i * lineSeparation;
            v1 = new Vector3f(x, 0.0f, 0.0f);
            v2 = new Vector3f(x, 0.0f, length.getY());
            if (!positions.contains(v1)) {
                positions.add(v1);
            }
            if (!positions.contains(v2)) {
                positions.add(v2);
            }
            integers.add(positions.indexOf(v1));
            integers.add(positions.indexOf(v2));
        }
        Vertex[] vertices = new Vertex[positions.size()];
        Integer[] indices = new Integer[integers.size()];
        for (int i2 = 0; i2 < vertices.length; ++i2) {
            vertices[i2] = new Vertex((Vector3f)positions.get(i2));
        }
        this.setVertices(vertices, UInteger.toIntArray(integers.toArray(indices)), false);
        this.setMode(MeshData.Mode.LINES);
    }
}

