/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.mesh;

import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.scenegraph.bounding.BoundingBox;

public class Mesh {
    protected MeshData data;
    protected BoundingBox bb;

    public Mesh(MeshData data) {
        this.data = data;
    }

    public Mesh(Vertex[] vertices, int[] indices) {
        this(vertices, indices, false);
    }

    public Mesh(Vertex[] vertices, int[] indices, boolean calcNormals) {
        this();
        this.setVertices(vertices, indices, calcNormals);
    }

    public Mesh() {
        this.data = new MeshData();
    }

    protected void setVertices(Vertex[] vertices, int[] indices) {
        this.setVertices(vertices, indices, true);
    }

    protected void setVertices(Vertex[] vertices, int[] indices, boolean calcNormals) {
        if (calcNormals) {
            this.calcNormals(vertices, indices);
        }
        this.data.set(vertices, indices);
        this.updateBounds();
    }

    public void setMode(MeshData.Mode mode) {
        this.getData().setMode(mode);
    }

    public void updateBounds() {
        this.bb = new BoundingBox().fromVertices(this.getData().getVertices());
    }

    protected void calcNormals(Vertex[] vertices, int[] indices) {
        for (int i = 0; i < indices.length; i += 3) {
            int i0 = indices[i];
            int i1 = indices[i + 1];
            int i2 = indices[i + 2];
            Vector3f v1 = vertices[i1].getPos().sub(vertices[i0].getPos());
            Vector3f v2 = vertices[i2].getPos().sub(vertices[i0].getPos());
            Vector3f normal = v1.cross(v2).normalized();
            vertices[i0].setNormal(vertices[i0].getNormal().add(normal));
            vertices[i1].setNormal(vertices[i1].getNormal().add(normal));
            vertices[i2].setNormal(vertices[i2].getNormal().add(normal));
        }
        for (Vertex vertex : vertices) {
            vertex.getNormal().normalize();
        }
    }

    protected void setData(MeshData data) {
        this.data = data;
        this.updateBounds();
    }

    public BoundingBox getBoundingBox() {
        return this.bb;
    }

    public int getVertexCount() {
        return this.getData().getVertexCount();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.bb = boundingBox;
    }

    public MeshData getData() {
        return this.data;
    }
}

