/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.mesh;

import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;

public class Quad
extends Mesh {
    protected float width;
    protected float height;

    public Quad() {
        this(1.0f, 1.0f, false);
    }

    public Quad(Dimension size) {
        this(size, false);
    }

    public Quad(Dimension size, boolean flip) {
        this(size.getWidth(), size.getHeight(), flip);
    }

    public Quad(float width, float height) {
        this(width, height, false);
    }

    public Quad(int width, int height) {
        this((float)width, (float)height);
    }

    public Quad(float width, float height, boolean flip) {
        this.width = width;
        this.height = height;
        this.generate(flip);
    }

    protected void generate(boolean flip) {
        Vector2f[] texCoords = flip ? new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 0.0f)} : new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        Vertex[] vertices = new Vertex[]{new Vertex(new Vector3f(0.0f, this.height, 0.0f), texCoords[0], new Vector3f(0.0f, 0.0f, -1.0f)), new Vertex(new Vector3f(this.width, this.height, 0.0f), texCoords[1], new Vector3f(0.0f, 0.0f, -1.0f)), new Vertex(new Vector3f(this.width, 0.0f, 0.0f), texCoords[2], new Vector3f(0.0f, 0.0f, -1.0f)), new Vertex(new Vector3f(0.0f, 0.0f, 0.0f), texCoords[3], new Vector3f(0.0f, 0.0f, -1.0f))};
        this.setVertices(vertices, new int[]{0, 1, 2, 0, 2, 3}, false);
    }
}

