/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.shadow;

import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.QuickPassFilter;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.RenderPass;
import org.achtern.AchternEngine.core.rendering.framebuffer.FrameBuffer;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.shader.ShadowGenerator;
import org.achtern.AchternEngine.core.rendering.shadow.ShadowInfo;
import org.achtern.AchternEngine.core.rendering.state.Face;
import org.achtern.AchternEngine.core.rendering.state.Feature;
import org.achtern.AchternEngine.core.rendering.texture.Filter;
import org.achtern.AchternEngine.core.rendering.texture.Format;
import org.achtern.AchternEngine.core.rendering.texture.InternalFormat;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Camera;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.BaseLight;

public class BasicShadowRenderer
extends QuickPassFilter
implements RenderPass {
    protected FrameBuffer shadowMap;
    protected Camera camera;
    protected Matrix4f bias;

    public void init(RenderEngine renderEngine) {
        this.shadowMap = new FrameBuffer(new Dimension(1024, 1024));
        this.shadowMap.setDepthTarget(new Texture(new Dimension(1024, 1024), Filter.NEAREST, Filter.NEAREST, InternalFormat.DEPTH_COMPONENT, Format.DEPTH, false));
        renderEngine.addTexture("shadowMap", this.shadowMap.getDepthTarget().getTexture());
        Node holder = new Node();
        this.camera = new Camera();
        holder.add(this.camera);
        this.bias = new Matrix4f().initScale(0.5f, 0.5f, 0.5f);
        this.bias = this.bias.mul(new Matrix4f().initTranslation(1.0f, 1.0f, 1.0f));
    }

    public void pre(Node node, RenderPass pass, RenderEngine renderEngine) {
        if (pass instanceof BaseLight) {
            ShadowInfo shadowInfo = ((BaseLight)pass).getShadowInfo();
            if (shadowInfo != null) {
                renderEngine.getDataBinder().bindAsRenderTarget(this.shadowMap);
                renderEngine.getState().clear(false, true, false);
                this.camera.setProjection(shadowInfo.getMatrix());
                this.camera.getTransform().setPosition(((BaseLight)pass).getTransform().getTransformedPosition());
                this.camera.getTransform().setRotation(((BaseLight)pass).getTransform().getTransformedRotation());
                this.camera.getTransform().rotate(this.camera.getTransform().getRotation().getUp(), 180.0f);
                renderEngine.addMatrix("shadowMatrix", this.bias.mul(this.camera.getViewProjection()));
                Camera mainC = renderEngine.getCamera();
                RenderPass mainRP = renderEngine.getActiveRenderPass();
                Face cullFace = null;
                if (renderEngine.getState().isEnabled(Feature.CULL_FACE) && shadowInfo.getCullFace() != null) {
                    cullFace = renderEngine.getState().getCullFace();
                    renderEngine.getState().cullFace(shadowInfo.getCullFace());
                }
                renderEngine.setCamera(this.camera);
                renderEngine.setActiveRenderPass(this);
                renderEngine.getDataBinder().bind(ShadowGenerator.getInstance());
                node.render(renderEngine);
                if (cullFace != null) {
                    renderEngine.getState().cullFace(cullFace);
                }
                renderEngine.setCamera(mainC);
                renderEngine.setActiveRenderPass(mainRP);
            }
            renderEngine.getRenderTarget().bindAsRenderTarget(renderEngine.getDataBinder());
        }
    }

    public Shader getShader() {
        return ShadowGenerator.getInstance();
    }
}

