/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.rendering.Dimension;

public class ResourceConverter {
    private static final ColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private static final ColorModel glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public static ByteBuffer toByteBuffer(BufferedImage image) {
        return ResourceConverter.toByteBuffer(image, Dimension.fromBufferedImage(image));
    }

    public static ByteBuffer toByteBuffer(BufferedImage image, Dimension dimension) {
        return ResourceConverter.toByteBuffer(image, dimension, PaddingMode.CENTER);
    }

    public static ByteBuffer toByteBuffer(BufferedImage image, Dimension dimension, PaddingMode mode) {
        BufferedImage texI;
        ByteBuffer buffer = null;
        boolean scale = true;
        if (image.getWidth() == dimension.getWidth() && image.getHeight() == dimension.getHeight()) {
            scale = false;
        }
        Dimension textureD = scale ? dimension.factor2() : Dimension.fromBufferedImage(image).factor2();
        boolean alpha = image.getColorModel().hasAlpha();
        if (alpha) {
            WritableRaster raster = Raster.createInterleavedRaster(0, textureD.getWidth(), textureD.getHeight(), 4, null);
            texI = new BufferedImage(glAlphaColorModel, raster, false, new Hashtable());
        } else {
            WritableRaster raster = Raster.createInterleavedRaster(0, textureD.getWidth(), textureD.getHeight(), 3, null);
            texI = new BufferedImage(glColorModel, raster, false, new Hashtable());
        }
        Graphics2D g = (Graphics2D)texI.getGraphics();
        if (alpha) {
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, textureD.getWidth(), textureD.getHeight());
        }
        if (scale) {
            Dimension drawScale = ResourceConverter.fit(Dimension.fromBufferedImage(image), textureD);
            Vector2f drawPosition = ResourceConverter.getForPadding(textureD, drawScale, mode);
            g.drawImage(image, (int)drawPosition.getX(), (int)drawPosition.getY(), drawScale.getWidth(), drawScale.getHeight(), null);
        } else {
            g.drawImage((Image)image, 0, 0, null);
        }
        byte[] data = ((DataBufferByte)texI.getRaster().getDataBuffer()).getData();
        buffer = ByteBuffer.allocateDirect(data.length);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(data, 0, data.length);
        buffer.flip();
        g.dispose();
        return buffer;
    }

    protected static Dimension fit(Dimension image, Dimension bounds) {
        Dimension fit = new Dimension(image);
        if (image.getWidth() > bounds.getWidth()) {
            fit.setWidth(bounds.getWidth());
            fit.setHeight(fit.getWidth() * image.getHeight() / image.getWidth());
        }
        if (image.getHeight() > bounds.getHeight()) {
            fit.setHeight(bounds.getHeight());
            fit.setWidth(fit.getHeight() * image.getWidth() / image.getHeight());
        }
        return fit;
    }

    protected static Vector2f getForPadding(Dimension drawSpace, Dimension size, PaddingMode mode) {
        Vector2f drawPosition = new Vector2f(0.0f, 0.0f);
        switch (mode) {
            case CENTER: {
                drawPosition.set(drawSpace.getX() / 2.0f, drawPosition.getY() / 2.0f);
                break;
            }
            case V_CENTER: 
            case LEFT: {
                drawPosition.setY(drawSpace.getY() / 2.0f);
                break;
            }
            case H_CENTER: {
                drawPosition.setX(drawSpace.getX() / 2.0f);
                break;
            }
            case RIGHT: {
                drawPosition.setY(drawSpace.getY() / 2.0f);
                drawPosition.setX(drawSpace.getX() - size.getX());
                break;
            }
            default: {
                throw new IllegalArgumentException("PaddingMode not supported!");
            }
        }
        return drawPosition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaddingMode {
        H_CENTER,
        V_CENTER,
        LEFT,
        RIGHT,
        CENTER;

    }
}

