/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceCache;
import org.achtern.AchternEngine.core.resource.ResourceLocation;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.loader.AsciiFileLoader;
import org.achtern.AchternEngine.core.resource.loader.BinaryLoader;
import org.achtern.AchternEngine.core.resource.loader.GLSLProgramLoader;
import org.achtern.AchternEngine.core.resource.loader.MeshLoader;
import org.achtern.AchternEngine.core.resource.loader.ShaderSourceLoader;
import org.achtern.AchternEngine.core.resource.loader.TextureLoader;
import org.achtern.AchternEngine.core.resource.loader.json.FigureLoader;
import org.achtern.AchternEngine.core.resource.locations.BundledFigureLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledModelLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledShaderLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledShaderProgramLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledTextureLocation;
import org.achtern.AchternEngine.core.resource.locations.ClasspathLocation;
import org.achtern.AchternEngine.core.resource.locations.FileSystemLocation;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResourceLoader.class);
    public static final String SHADER_PROGRAM_EXT = ".yaml";
    public static final String FIGURE_DECLARATION_EXT = ".json";
    private static ResourceCache binaryCache = new ResourceCache();
    private static ResourceCache<String> fileCache = new ResourceCache();
    private static List<ResourceLocation> locations = new ArrayList<ResourceLocation>();

    public static void addResourceLocation(ResourceLocation location) {
        locations.add(location);
    }

    public static void pushResourceLocation(ResourceLocation location) {
        locations.add(0, location);
    }

    public static void removeResourceLocation(ResourceLocation location) {
        locations.remove(location);
    }

    public static void clearResourceLocations() {
        locations.clear();
    }

    public static List<ResourceLocation> getResourceLocations() {
        return locations;
    }

    public static void preLoadMesh(String name) throws Exception {
        ResourceLoader.getMesh(name);
    }

    public static void preLoadTexture(String name) throws Exception {
        ResourceLoader.getTexture(name);
    }

    public static void preLoadShader(String name) throws Exception {
        ResourceLoader.getShader(name);
    }

    public static Figure getFigure(String name) throws Exception {
        return ResourceLoader.getFigure(name, false);
    }

    public static Figure getFigure(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Figure {}", (Object)name);
        return ResourceLoader.load(name + FIGURE_DECLARATION_EXT, new FigureLoader(), forceLoading);
    }

    public static Mesh getMesh(String name) throws Exception {
        return ResourceLoader.getMesh(name, false);
    }

    public static Mesh getMesh(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Mesh {}", (Object)name);
        return ResourceLoader.load(name, new MeshLoader(), forceLoading);
    }

    public static Texture getTexture(String name) throws Exception {
        return ResourceLoader.getTexture(name, null, false);
    }

    public static Texture getTexture(String name, Dimension dimension) throws Exception {
        return ResourceLoader.getTexture(name, dimension, false);
    }

    public static Texture getTexture(String name, Dimension dimension, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Texture {}", (Object)name);
        return ResourceLoader.load(name, new TextureLoader(dimension), forceLoading);
    }

    public static String getShader(String name) throws Exception {
        return ResourceLoader.load(name, new ShaderSourceLoader(), false);
    }

    public static String getShader(String name, boolean forceLoading) throws Exception {
        return ResourceLoader.load(name, new ShaderSourceLoader(), forceLoading);
    }

    public static String getShader(String name, boolean forceLoading, LineBasedParser parser) throws Exception {
        LOGGER.info("Loading Shader Source {}", (Object)name);
        return ResourceLoader.load(name, new ShaderSourceLoader(parser), forceLoading);
    }

    public static GLSLProgram getShaderProgram(String name) throws Exception {
        return ResourceLoader.getShaderProgram(name, false);
    }

    public static GLSLProgram getShaderProgram(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Shader Program {}", (Object)name);
        return ResourceLoader.load(name + SHADER_PROGRAM_EXT, new GLSLProgramLoader(), forceLoading);
    }

    public static <T> T load(String name, AsciiFileLoader<T> loader, boolean forceLoading) throws Exception {
        String file = ResourceLoader.readFile(name, forceLoading, loader.getPreProcessor());
        loader.load(name, file);
        return loader.get();
    }

    public static <T, C> T load(String name, BinaryLoader<T, C> loader, boolean forceLoading) throws Exception {
        if (binaryCache.has(name) && !forceLoading) {
            Object cache = binaryCache.get(name);
            if (loader.getCacheType() == null) {
                throw new IllegalStateException("Missing Cache Type. BinaryLoader invalid.");
            }
            if (loader.getCacheType().isAssignableFrom(cache.getClass())) {
                return loader.fromCache(cache);
            }
        }
        loader.load(name, ResourceLoader.getStream(name));
        Object value = loader.get();
        binaryCache.add(name, loader.getCache());
        return value;
    }

    public static String readFile(String name) throws IOException {
        return ResourceLoader.readFile(name, false);
    }

    public static String readFile(String name, boolean forceLoading) throws IOException {
        return ResourceLoader.readFile(name, forceLoading, null);
    }

    public static String readFile(String name, boolean forceLoading, LineBasedParser parser) throws IOException {
        String line;
        if (fileCache.has(name) && !forceLoading) {
            return fileCache.get(name);
        }
        StringBuilder file = new StringBuilder();
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(ResourceLoader.getStream(name)));
        long lines = 0L;
        while ((line = fileReader.readLine()) != null) {
            if (LOGGER.isDebugEnabled()) {
                ++lines;
            }
            try {
                if (parser != null) {
                    file.append(parser.parse(line)).append("\n");
                    continue;
                }
                file.append(line).append("\n");
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                LOGGER.warn("Non IOException when loading file <" + name + ">", (Throwable)e);
            }
        }
        fileReader.close();
        LOGGER.debug("Loaded {} lines from file {}", (Object)lines, (Object)name);
        fileCache.add(name, file.toString());
        return file.toString();
    }

    public static boolean exists(String name) {
        try {
            URL dumpVOID = ResourceLoader.getURL(name);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static InputStream getStream(String name) throws IOException {
        ResourceLocation location;
        InputStream is = null;
        Iterator<ResourceLocation> i$ = locations.iterator();
        while (i$.hasNext() && (is = (location = i$.next()).getStream(name)) == null) {
        }
        if (is == null) {
            throw new IOException("Resource not found in locations. <" + name + ">");
        }
        return new BufferedInputStream(is);
    }

    public static URL getURL(String name) throws IOException {
        ResourceLocation location;
        URL url = null;
        Iterator<ResourceLocation> i$ = locations.iterator();
        while (i$.hasNext() && (url = (location = i$.next()).getURL(name)) == null) {
        }
        if (url == null) {
            throw new IOException("Resource not found in locations. <" + name + ">");
        }
        return url;
    }

    static {
        locations.add(new ClasspathLocation());
        locations.add(new BundledTextureLocation());
        locations.add(new BundledModelLocation());
        locations.add(new BundledFigureLocation());
        locations.add(new BundledShaderLocation());
        locations.add(new BundledShaderProgramLocation());
        locations.add(new FileSystemLocation("."));
    }
}

