/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.achtern.AchternEngine.core.resource.fileparser.ParsingException;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;

@Deprecated
public class FigureParser {
    public static final String BLOCK_OPEN = "{";
    public static final String BLOCK_CLOSE = "}";
    public static final String MESH_BLOCK = "Mesh";
    public static final String MATERIAL_BLOCK = "Material";
    public static final String TEXTURE_BLOCK = "Texture";
    public static final String FLOAT_BLOCK = "float";
    public static final String FILE_STATEMENT = "file";
    public static final String DRAW_STRATEGY_BLOCK = "DrawStrategy";
    public static final String MATERIAL_WIREFRAME_DRAW_KEY = "wireframe";
    public static final String TEXTURE_ALPHA_STATEMENT = "alpha";
    public static final String PACKAGE_SEARCH_INDICATOR = "@";
    public static final String ASSIGNMENT_CHARACTER = "=";
    public static final String TOKEN_INDICATOR = "$";
    public static final String TOKEN_CUSTOM_INDICATOR = "&";
    public static final String TOKEN_BLOCK_START = "$BLOCK_START(%s)";
    public static final String TOKEN_BLOCK_END = "$BLOCK_END(%s)";
    public static final String TOKEN_PACKAGE_SEARCH = "$PACKAGE_SEARCH_FOR(%s)";
    public static final String TOKEN_MATERIAL_WIREFRAME = "$WIREFRAME(%s)";
    public static final String TOKEN_TEXTURE_ALPHA = "$ALPHA(%s)";
    public static final String TOKEN_FILE = "$FILE(%s)";
    public static final String TOKEN_VALUE_ASSIGNMENT = "&%s(%s)";
    public static final Pattern PATTERN_FIRST_BLOCK = Pattern.compile("\\$BLOCK_START\\(&([A-Za-z0-9]*)\\)");
    protected String source;
    protected List<String> tokens;

    protected Figure get() throws ParsingException {
        String name = this.tokens.get(0);
        Matcher nameMater = PATTERN_FIRST_BLOCK.matcher(name);
        if (!nameMater.find()) {
            throw new ParsingException("Could not get Figure name from token stream");
        }
        Figure figure = new Figure(nameMater.group());
        return figure;
    }

    protected void tokenize() throws ParsingException {
        String[] lines = this.source.split("\n");
        this.tokens = new ArrayList<String>(lines.length);
        int blockLevel = 0;
        String previousBlock = "";
        for (String l : lines) {
            if ((l = l.trim()).isEmpty()) continue;
            if (l.contains(BLOCK_OPEN)) {
                String name = l.substring(0, l.indexOf(BLOCK_OPEN)).trim();
                String token = FigureParser.buildInBlock(name) ? TOKEN_INDICATOR : TOKEN_CUSTOM_INDICATOR;
                this.tokens.add(String.format(TOKEN_BLOCK_START, previousBlock + token + name));
                previousBlock = previousBlock + token + name;
                ++blockLevel;
            } else if (l.contains(BLOCK_CLOSE)) {
                if (blockLevel == 0) {
                    System.out.println("Reached end statements");
                } else {
                    this.tokens.add(String.format(TOKEN_BLOCK_END, previousBlock));
                    int tI = previousBlock.lastIndexOf(TOKEN_INDICATOR);
                    int cI = previousBlock.lastIndexOf(TOKEN_CUSTOM_INDICATOR);
                    previousBlock = tI == -1 && cI == -1 || tI == 0 && cI == -1 || tI == -1 && cI == 0 ? "" : previousBlock.substring(0, tI > cI ? tI : cI);
                    --blockLevel;
                }
            } else {
                String value;
                String name;
                String[] parts;
                if (blockLevel == 0) {
                    throw new ParsingException("Block Level cannot be null");
                }
                if (blockLevel == 2) {
                    String clazz;
                    if (previousBlock.endsWith("$Mesh")) {
                        if (l.startsWith(PACKAGE_SEARCH_INDICATOR)) {
                            clazz = l.substring(1);
                            this.tokens.add(String.format(TOKEN_PACKAGE_SEARCH, clazz));
                        }
                    } else if (previousBlock.endsWith("$Material")) {
                        if (l.startsWith(MATERIAL_WIREFRAME_DRAW_KEY)) {
                            parts = l.split(ASSIGNMENT_CHARACTER);
                            name = parts[0].trim();
                            assert (name.equalsIgnoreCase("MATERIAL_WIREFRAME_DRAW_KEY"));
                            value = parts[1].trim();
                            this.tokens.add(String.format(TOKEN_MATERIAL_WIREFRAME, value));
                        }
                    } else if (previousBlock.endsWith("$DrawStrategy") && l.startsWith(PACKAGE_SEARCH_INDICATOR)) {
                        clazz = l.substring(1);
                        this.tokens.add(String.format(TOKEN_PACKAGE_SEARCH, clazz));
                    }
                } else if (blockLevel == 3) {
                    if (previousBlock.endsWith("$Material$float")) {
                        if (!l.contains(ASSIGNMENT_CHARACTER)) {
                            throw new ParsingException("In float Block assignments are mandatory");
                        }
                        parts = l.split(ASSIGNMENT_CHARACTER);
                        name = parts[0].trim();
                        value = parts[1].trim();
                        this.tokens.add(String.format(TOKEN_VALUE_ASSIGNMENT, name, value));
                    }
                } else if (blockLevel == 4 && previousBlock.matches(".*\\$Material\\$Texture&([a-z]*)")) {
                    if (!l.contains(ASSIGNMENT_CHARACTER)) {
                        throw new ParsingException("In sub Texture Block assignments are mandatory");
                    }
                    parts = l.split(ASSIGNMENT_CHARACTER);
                    name = parts[0].trim();
                    value = parts[1].trim();
                    if (name.equalsIgnoreCase(FILE_STATEMENT)) {
                        this.tokens.add(String.format(TOKEN_FILE, value));
                    } else if (name.equalsIgnoreCase(TEXTURE_ALPHA_STATEMENT)) {
                        this.tokens.add(String.format(TOKEN_TEXTURE_ALPHA, value));
                    } else {
                        throw new ParsingException("Unexpected variable type " + name);
                    }
                }
            }
            previousBlock = previousBlock.trim();
        }
    }

    private static boolean buildInBlock(String name) {
        return name.equalsIgnoreCase(MESH_BLOCK) || name.equalsIgnoreCase(TEXTURE_BLOCK) || name.equalsIgnoreCase(MATERIAL_BLOCK) || name.equalsIgnoreCase(FLOAT_BLOCK) || name.equalsIgnoreCase(DRAW_STRATEGY_BLOCK);
    }
}

