/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.fileparser.VariableBasedLanguageParser;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLStruct;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLParser
extends VariableBasedLanguageParser
implements LineBasedParser {
    public static final Logger LOGGER = LoggerFactory.getLogger(GLSLParser.class);
    public static final String CUSTOM_TOKEN_INCLUDE = "#include";
    public static final String CUSTOM_TOKEN_IMPORT = "#import";
    public static final String TOKEN_SPACE = " ";
    public static final String TOKEN_UNIFORM = "uniform";
    public static final String TOKEN_ATTRIBUTE = "attribute";
    public static final String TOKEN_STRUCT = "struct";
    public static final String TOKEN_END_STATEMENT = ";";
    public static final String TOKEN_SINGLE_LINE_COMMENT = "//";
    public static final String INCLUDE_DIRECTORY = "include/";

    @Override
    public String parse(String line) throws Exception {
        if ((line = line.trim()).contains(TOKEN_SINGLE_LINE_COMMENT)) {
            line = line.substring(0, line.indexOf(TOKEN_SINGLE_LINE_COMMENT));
        }
        if (line.startsWith(CUSTOM_TOKEN_INCLUDE)) {
            String filename = line.substring(CUSTOM_TOKEN_INCLUDE.length() + 2, line.length() - 1);
            line = ResourceLoader.getShader(INCLUDE_DIRECTORY + filename);
        } else if (line.startsWith(CUSTOM_TOKEN_IMPORT)) {
            String filename = line.substring(CUSTOM_TOKEN_IMPORT.length() + 2, line.length() - 1);
            line = ResourceLoader.getShader(INCLUDE_DIRECTORY + filename);
        }
        return line;
    }

    public List<GLSLStruct> getStructs(String text) {
        boolean hasMore;
        ArrayList<GLSLStruct> structs = new ArrayList<GLSLStruct>();
        int startLoc = text.indexOf(TOKEN_STRUCT);
        boolean bl = hasMore = startLoc != -1;
        while (hasMore) {
            startLoc = text.indexOf(TOKEN_STRUCT);
            text = text.substring(startLoc);
            startLoc = text.indexOf(TOKEN_STRUCT);
            String struct = text.substring(startLoc, text.indexOf("};"));
            String[] structParts = struct.split("\\{");
            String head = structParts[0].trim();
            String body = structParts[1];
            if (!(body = body.replace("    ", "\t").replace("   ", "\t").replace("  ", "\t").replace("\n", "\t")).startsWith("\t")) {
                body = "\t" + body;
            }
            String name = head.substring(TOKEN_STRUCT.length() + 1, head.length());
            List<Variable> variables = GLSLParser.getVariables(body, "\t");
            structs.add(new GLSLStruct(name, variables));
            if ((text = text.substring(struct.length() + 1 + TOKEN_END_STATEMENT.length())).contains(TOKEN_STRUCT)) continue;
            hasMore = false;
        }
        return structs;
    }

    public GLSLScript process(GLSLScript script) {
        List<Variable> uniforms = GLSLParser.getVariables(script.getSource(), TOKEN_UNIFORM);
        script.setUniformsFromVariable(uniforms);
        script.setStructs(this.getStructs(script.getSource()));
        script.setAttributes(this.getAttributes(script.getSource()));
        script.setExpandedUniforms(this.getExpandedUniforms(script.getSource(), uniforms, script.getStructs()));
        script.setProcessed(true);
        return script;
    }

    public List<Uniform> getExpandedUniforms(String text, List<Variable> uniforms, List<GLSLStruct> structs) {
        ArrayList<Uniform> finalUniforms = new ArrayList<Uniform>();
        if (LOGGER.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Variable v : uniforms) {
                sb.append(v.getName());
                sb.append(TOKEN_END_STATEMENT);
            }
            LOGGER.trace("Found the following uniforms: <{}>", (Object)sb.toString());
        }
        List<Variable> primitives = GLSLParser.filterPrimitives(uniforms);
        uniforms.removeAll(primitives);
        for (Variable v : primitives) {
            finalUniforms.add(new Uniform(v));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Added the following primitve uniforms:");
            for (Variable v : primitives) {
                LOGGER.trace("    <{}>{}<{}>", new Object[]{v.getType(), v.getName(), v.getType()});
            }
        }
        if (LOGGER.isTraceEnabled()) {
            GLSLParser.printStructs(structs);
        }
        for (Variable v : uniforms) {
            LOGGER.trace("Trying to match ({} {}) against struct list", (Object)v.getType(), (Object)v.getName());
            GLSLStruct match = GLSLParser.findNameInList(v.getType(), structs);
            if (match != null) {
                LOGGER.trace("Found a match, now expanding");
                for (String expanded : GLSLParser.expandUniform(v, match, structs)) {
                    finalUniforms.add(new Uniform(match.getName(), expanded));
                }
                continue;
            }
            LOGGER.debug("Did not found struct specified by uniform type! ({} {})", (Object)v.getType(), (Object)v.getName());
            finalUniforms.add(new Uniform(v));
        }
        return finalUniforms;
    }

    public List<Variable> getAttributes(String text) {
        return GLSLParser.getVariables(text, TOKEN_ATTRIBUTE);
    }

    public static List<Variable> getVariables(String text, String token) {
        boolean hasMore;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        int startLoc = text.indexOf(token);
        boolean bl = hasMore = startLoc != -1;
        while (hasMore) {
            startLoc = text.indexOf(token);
            text = text.substring(startLoc);
            startLoc = text.indexOf(token);
            if (text.length() < 2) {
                hasMore = false;
                continue;
            }
            String variable = text.substring(startLoc, text.indexOf(TOKEN_END_STATEMENT));
            String[] parts = variable.split("\\s+");
            assert (parts[0].trim().equalsIgnoreCase(token.trim()));
            String type = parts[1];
            String name = parts[2];
            vars.add(new Variable(type, name));
            LOGGER.trace("<{}>{}</{}>", new Object[]{type, name, type});
            if ((text = text.substring(variable.length() + TOKEN_END_STATEMENT.length())).contains(token)) continue;
            LOGGER.trace("Finished parsing shader text.");
            hasMore = false;
        }
        return vars;
    }

    public static List<String> expandUniform(Variable uniform, GLSLStruct main, List<GLSLStruct> structs) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Job: Expand <uniform {} {}>", (Object)uniform.getType(), (Object)uniform.getName());
            List<String> r = GLSLParser.expendVariable(uniform, main, structs);
            LOGGER.trace("uniform {} {} got expanded to:", (Object)uniform.getType(), (Object)uniform.getName());
            for (String s : r) {
                LOGGER.trace(s);
            }
            return r;
        }
        return GLSLParser.expendVariable(uniform, main, structs);
    }

    public static List<String> expendVariable(Variable variable, GLSLStruct main, List<GLSLStruct> structs) {
        ArrayList<String> r = new ArrayList<String>();
        for (Variable member : main.getMembers()) {
            LOGGER.trace("Working on member:{} {}", (Object)member.getType(), (Object)member.getName());
            if (GLSLParser.isPrimitive(member)) {
                LOGGER.trace("Just added this member. Next!");
                r.add(member.getName());
                continue;
            }
            GLSLStruct s = GLSLParser.findNameInList(member.getType(), structs);
            if (s != null) {
                LOGGER.trace("Making recursiv call to expand this member {} {} with struct provided: {}", new Object[]{member.getType(), member.getName(), s.getName()});
                r.addAll(GLSLParser.expendVariable(member, s, structs));
                continue;
            }
            LOGGER.trace("Missing struct for variable {} {}", (Object)variable.getType(), (Object)variable.getName());
            r.add(member.getName());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("variable {} {} got expanded to:", (Object)variable.getType(), (Object)variable.getName());
            for (String s : r) {
                LOGGER.trace(s);
            }
        }
        ArrayList<String> finalList = new ArrayList<String>(r.size());
        for (String expanded : r) {
            finalList.add(variable.getName() + "." + expanded);
        }
        return finalList;
    }

    protected static List<Variable> filterPrimitives(List<Variable> variables) {
        ArrayList<Variable> primitives = new ArrayList<Variable>();
        for (Variable v : variables) {
            if (!GLSLParser.isPrimitive(v)) continue;
            primitives.add(v);
        }
        return primitives;
    }

    protected static boolean isPrimitive(Variable v) {
        boolean upperCase = Character.isUpperCase(v.getType().trim().charAt(0));
        return !upperCase;
    }

    protected static GLSLStruct findNameInList(String name, List<GLSLStruct> structs) {
        for (GLSLStruct s : structs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    protected static void printStructs(List<GLSLStruct> structs) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Printing all structs in list!");
            for (GLSLStruct struct : structs) {
                LOGGER.trace("<{}>", (Object)struct.getName());
                for (Variable v : struct.getMembers()) {
                    LOGGER.trace("\t<{}>{}</{}>", new Object[]{v.getType(), v.getName(), v.getType()});
                }
                LOGGER.trace("</{}>", (Object)struct.getName());
            }
            LOGGER.trace("Done.");
        }
    }
}

