/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.achtern.AchternEngine.core.resource.fileparser.ParsingException;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.statement.BlockExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineSeparator {
    public static final Logger LOGGER = LoggerFactory.getLogger(PipelineSeparator.class);
    public static final String PIPELINE_SEPARATOR_START = "#---";
    public static final String PIPELINE_SEPARATOR_END = "---#";
    public static final String PIPELINE_END = "#---END---#";
    protected final String source;

    public PipelineSeparator(String source) {
        this.source = source;
    }

    public List<String> getGlobals() {
        String globals = this.getSource().substring(0, this.getSource().indexOf(PIPELINE_SEPARATOR_START));
        String[] lines = globals.split("\n");
        ArrayList<String> globalStatements = new ArrayList<String>(lines.length);
        for (String l : lines) {
            globalStatements.add(l.trim());
        }
        return globalStatements;
    }

    protected Map<String, String> getBlocks() throws ParsingException {
        String removedGlobals = this.getSource().substring(this.getSource().indexOf(PIPELINE_SEPARATOR_START), this.getSource().length());
        String[] blocks = removedGlobals.split(PIPELINE_END);
        HashMap<String, String> processedBlocks = new HashMap<String, String>(blocks.length);
        for (String block : blocks) {
            BlockExtractor extractor = new BlockExtractor(block);
            if (!extractor.getTargetMatcher().matches()) {
                throw new ParsingException("Block doesn't match regex.\n>>" + block + "<<\n");
            }
            String type = extractor.getType().trim();
            String content = extractor.getContent().trim();
            processedBlocks.put(type, content);
        }
        return processedBlocks;
    }

    public String getSource() {
        return this.source;
    }
}

