/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.controller;

import org.achtern.AchternEngine.core.GameDebugger;
import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.math.Quaternion;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;
import org.achtern.AchternEngine.core.scenegraph.scanning.FigureRetriever;

public class Chaser
extends QuickEntity
implements GameDebugger.DebugStateListener {
    public boolean debug;
    protected float speed;
    protected float minDist;
    protected float maxDist;
    protected Node chaseTo;
    protected boolean disabled;
    protected boolean idle;
    private Figure cacheFigure;
    private String tmpName;

    public Chaser(Node to, float speed) {
        this(to, speed, 5.0f, 50.0f);
    }

    public Chaser(String to, float speed) {
        this(to, speed, 5.0f, 50.0f);
    }

    public Chaser(Node to) {
        this(to, 10.0f, 5.0f, 50.0f);
    }

    public Chaser(String to) {
        this(to, 10.0f, 5.0f, 50.0f);
    }

    public Chaser(Node to, float speed, float minDist, float maxDist) {
        super("Chaser");
        this.chaseTo = to;
        this.speed = speed;
        this.minDist = minDist;
        this.maxDist = maxDist;
    }

    public Chaser(String to, float speed, float minDist, float maxDist) {
        super("Chaser");
        this.speed = speed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.tmpName = to;
    }

    public void update(float delta) {
        super.update(delta);
        if (this.chaseTo == null || this.tmpName == null) {
            this.init();
        }
        if (this.disabled) {
            return;
        }
        float distance = this.chaseTo.getTransform().getPosition().euclidean(this.getTransform().getPosition());
        if (!(distance > this.maxDist)) {
            this.look(delta);
        }
        if (distance > this.maxDist || distance < this.minDist) {
            if (!this.idle) {
                this.idle = true;
                if (this.debug) {
                    this.getFigure().getMaterial().setColor(Color.RED);
                }
            }
            return;
        }
        if (this.idle && this.debug) {
            this.getFigure().getMaterial().setColor(Color.GREEN);
        }
        this.idle = false;
        this.getTransform().getPosition().addLocal(this.getTransform().getRotation().getForward().mul(this.speed * delta));
    }

    protected void look(float delta) {
        Quaternion nR = this.getTransform().getFaceAt(this.chaseTo.getTransform().getTransformedPosition(), Transform.Y_AXIS);
        this.getTransform().setRotation(this.getTransform().getRotation().nlerp(nR, delta * 5.0f, true));
    }

    protected Figure getFigure() {
        return this.cacheFigure;
    }

    public void disable() {
        this.setDisabled(true);
    }

    public void enable() {
        this.setDisabled(false);
    }

    public void toogle() {
        this.setDisabled(!this.isDisabled());
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (disabled && this.debug) {
            this.getFigure().getMaterial().setColor(Color.YELLOW);
        } else if (this.debug) {
            if (this.idle) {
                this.getFigure().getMaterial().setColor(Color.RED);
            } else {
                this.getFigure().getMaterial().setColor(Color.GREEN);
            }
        }
    }

    public void changed(boolean enabled) {
        this.debug = enabled;
    }

    protected void init() {
        if (this.chaseTo == null) {
            this.chaseTo = this.getEngine().getGame().get(this.tmpName);
        } else {
            this.tmpName = this.chaseTo.getName();
        }
        FigureRetriever retriever = new FigureRetriever();
        retriever.scan(this.getParent());
        this.cacheFigure = retriever.get().get(0);
        if (this.getEngine().getGame().getDebugger() != null) {
            this.getEngine().getGame().getDebugger().register(this, true);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

