/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.controller;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.scenegraph.entity.controller.SimpleMover;

public class FlyMover
extends SimpleMover {
    protected Key upKey;
    protected Key downKey;

    public FlyMover(float speed) {
        this(speed, Key.SPACE, Key.LSHIFT);
    }

    public FlyMover(float speed, Key upKey, Key downKey) {
        super(speed);
        this.upKey = upKey;
        this.downKey = downKey;
    }

    protected void registerListener() {
        this.getEngine().getGame().getInputManager().getKeyMap().register(new KeyTrigger(this.upKey, KeyTrigger.Type.PRESS), (KeyListener)this).register(new KeyTrigger(this.downKey, KeyTrigger.Type.PRESS), (KeyListener)this);
    }

    public void onAction(KeyEvent event) {
        float amt = this.getSpeed() * event.getDelta();
        if (event.getKey().equals((Object)this.upKey)) {
            this.move(Transform.Y_AXIS, amt);
        } else if (event.getKey().equals((Object)this.downKey)) {
            this.move(Transform.Y_AXIS, -amt);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlyMover)) {
            return false;
        }
        FlyMover other = (FlyMover)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$upKey = this.getUpKey();
        Key other$upKey = other.getUpKey();
        if (this$upKey == null ? other$upKey != null : !((Object)((Object)this$upKey)).equals((Object)other$upKey)) {
            return false;
        }
        Key this$downKey = this.getDownKey();
        Key other$downKey = other.getDownKey();
        return !(this$downKey == null ? other$downKey != null : !((Object)((Object)this$downKey)).equals((Object)other$downKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlyMover;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $upKey = this.getUpKey();
        result = result * 59 + ($upKey == null ? 0 : ((Object)((Object)$upKey)).hashCode());
        Key $downKey = this.getDownKey();
        result = result * 59 + ($downKey == null ? 0 : ((Object)((Object)$downKey)).hashCode());
        return result;
    }

    public Key getUpKey() {
        return this.upKey;
    }

    public Key getDownKey() {
        return this.downKey;
    }

    public void setUpKey(Key upKey) {
        this.upKey = upKey;
    }

    public void setDownKey(Key downKey) {
        this.downKey = downKey;
    }

    public String toString() {
        return "FlyMover(upKey=" + (Object)((Object)this.getUpKey()) + ", downKey=" + (Object)((Object)this.getDownKey()) + ")";
    }
}

