/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.debug;

import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.generator.ImageGenerator;
import org.achtern.AchternEngine.core.rendering.mesh.Grid;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridDebugger
extends Node {
    public static final Logger LOGGER = LoggerFactory.getLogger(GridDebugger.class);
    protected Figure grid = new Figure("Grid");

    public GridDebugger() {
        this("Grid");
    }

    public GridDebugger(String name) {
        this(name, 50, 50, 1.0f);
    }

    public GridDebugger(int xCount, int yCount, float lineSeparation) {
        this("Grid", xCount, yCount, lineSeparation);
    }

    public GridDebugger(String name, int xCount, int yCount, float lineSeparation) {
        super(name);
        this.grid.setMesh(new Grid(xCount, yCount, lineSeparation));
        Material m = new Material();
        m.addTexture("diffuse", new Texture(ImageGenerator.bytesFromColor(Color.WHITE)));
        m.addFloat("specularIntensity", 1.0f);
        m.addFloat("specularPower", 8.0f);
        this.grid.setMaterial(m);
        this.add(this.grid);
    }
}

