/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light;

import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.light.Attenuation;
import org.achtern.AchternEngine.core.rendering.shader.forward.Point;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.BaseLight;

public class PointLight
extends BaseLight {
    private static final int COLOR_DEPTH = 256;
    protected Attenuation attenuation;
    protected float range;

    public PointLight(Color color, float intensity, Attenuation attenuation) {
        super(color, intensity);
        this.attenuation = attenuation;
        float e = attenuation.getExponent();
        float l = attenuation.getLinear();
        float c = attenuation.getConstant() - 256.0f * this.getIntensity() * this.getColor().getColor().max();
        this.range = (float)((double)(-l) + Math.sqrt(l * l - 4.0f * e * c)) / (2.0f * e);
        this.setShader(Point.getInstance());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointLight)) {
            return false;
        }
        PointLight other = (PointLight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Attenuation this$attenuation = this.getAttenuation();
        Attenuation other$attenuation = other.getAttenuation();
        if (this$attenuation == null ? other$attenuation != null : !((Object)this$attenuation).equals(other$attenuation)) {
            return false;
        }
        return Float.compare(this.getRange(), other.getRange()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointLight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Attenuation $attenuation = this.getAttenuation();
        result = result * 59 + ($attenuation == null ? 0 : ((Object)$attenuation).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getRange());
        return result;
    }

    public Attenuation getAttenuation() {
        return this.attenuation;
    }

    public float getRange() {
        return this.range;
    }

    public void setAttenuation(Attenuation attenuation) {
        this.attenuation = attenuation;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public String toString() {
        return "PointLight(attenuation=" + this.getAttenuation() + ", range=" + this.getRange() + ")";
    }
}

