/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light;

import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.light.Attenuation;
import org.achtern.AchternEngine.core.rendering.shader.forward.Spot;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.PointLight;

public class SpotLight
extends PointLight {
    protected float cutoff;

    public SpotLight(Color color, float intensity, Attenuation attenuation, float cutoff) {
        super(color, intensity, attenuation);
        this.cutoff = cutoff;
        this.setShader(Spot.getInstance());
    }

    public Vector3f getDirection() {
        return this.getTransform().getTransformedRotation().getForward();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpotLight)) {
            return false;
        }
        SpotLight other = (SpotLight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getCutoff(), other.getCutoff()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpotLight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getCutoff());
        return result;
    }

    public float getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(float cutoff) {
        this.cutoff = cutoff;
    }

    public String toString() {
        return "SpotLight(cutoff=" + this.getCutoff() + ")";
    }
}

