/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.scanning;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.bounding.BoundingBox;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.achtern.AchternEngine.core.scenegraph.scanning.EntityRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureRetriever
extends EntityRetriever {
    protected List<Figure> figures;
    protected List<Mesh> meshes;
    protected List<Material> materials;
    protected BoundingBox bb;

    @Override
    public void scan(Node node) {
        super.scan(node);
        this.figures = this.getAll(Figure.class);
        this.meshes = null;
        this.meshes = this.getMeshes();
        this.materials = null;
        this.materials = this.getMaterials();
        this.bb = this.getCompleteBoundingBox();
    }

    public List<Figure> get() {
        return this.figures;
    }

    public List<Mesh> getMeshes() {
        if (this.meshes != null) {
            return this.meshes;
        }
        this.meshes = new ArrayList<Mesh>(this.get().size());
        for (Figure f : this.get()) {
            this.meshes.add(f.getMesh());
        }
        return this.meshes;
    }

    public List<Material> getMaterials() {
        if (this.materials != null) {
            return this.materials;
        }
        this.materials = new ArrayList<Material>(this.get().size());
        for (Figure f : this.get()) {
            this.materials.add(f.getMaterial());
        }
        return this.materials;
    }

    public int getTotalVertexCount() {
        List<Mesh> meshList = this.getMeshes();
        int count = 0;
        for (Mesh m : meshList) {
            count += m.getData().getVertexCount();
        }
        return count;
    }

    public BoundingBox getCompleteBoundingBox() {
        if (this.bb != null) {
            return this.bb;
        }
        for (Mesh m : this.getMeshes()) {
            if (this.bb == null) {
                this.bb = new BoundingBox(m.getBoundingBox());
                continue;
            }
            this.bb.merge(m.getBoundingBox());
        }
        return this.bb;
    }
}

