/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.util;

import java.util.HashMap;
import java.util.Map;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.util.DataStore;

public class CommonDataStore
implements DataStore {
    protected Map<String, Texture> textures = new HashMap<String, Texture>();
    protected Map<String, Vector3f> vectors = new HashMap<String, Vector3f>();
    protected Map<String, Color> colors = new HashMap<String, Color>();
    protected Map<String, Float> floats = new HashMap<String, Float>();
    protected Map<String, Integer> integers = new HashMap<String, Integer>();
    protected Map<String, Matrix4f> matrices = new HashMap<String, Matrix4f>();

    public void addTexture(String name, Texture texture) {
        this.textures.put(name, texture);
    }

    public Texture getTexture(String name) {
        return this.textures.get(name);
    }

    public boolean hasTexture(String name) {
        return this.textures.containsKey(name);
    }

    public void addVector(String name, Vector3f vector) {
        this.vectors.put(name, vector);
    }

    public Vector3f getVector(String name) {
        Vector3f r = this.vectors.get(name);
        if (r != null) {
            return r;
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public boolean hasVector(String name) {
        return this.vectors.containsKey(name);
    }

    public void addColor(String name, Color color) {
        this.colors.put(name, color);
    }

    public Color getColor(String name) {
        return this.colors.get(name);
    }

    public boolean hasColor(String name) {
        return this.colors.containsKey(name);
    }

    public void addInteger(String name, int i) {
        this.integers.put(name, i);
    }

    public int getInteger(String name) {
        Integer r = this.integers.get(name);
        if (r != null) {
            return r;
        }
        return 0;
    }

    public boolean hasInteger(String name) {
        return this.integers.containsKey(name);
    }

    public void addFloat(String name, float f) {
        this.floats.put(name, Float.valueOf(f));
    }

    public float getFloat(String name) {
        Float r = this.floats.get(name);
        if (r != null) {
            return r.floatValue();
        }
        return 0.0f;
    }

    public boolean hasFloat(String name) {
        return this.floats.containsKey(name);
    }

    public void addMatrix(String name, Matrix4f matrix) {
        this.matrices.put(name, matrix);
    }

    public Matrix4f getMatrix(String name) {
        return this.matrices.get(name);
    }

    public boolean hasMatrix(String name) {
        return this.matrices.containsKey(name);
    }
}

