/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.rendering.binding;

import java.nio.FloatBuffer;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.math.Vector4f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.binding.UniformManager;
import org.achtern.AchternEngine.core.rendering.fog.Fog;
import org.achtern.AchternEngine.core.rendering.light.Attenuation;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.AmbientLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.BaseLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.DirectionalLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.PointLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.SpotLight;
import org.achtern.AchternEngine.core.util.UBuffer;
import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWJGLUniformManager
implements UniformManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(LWJGLUniformManager.class);

    public void registerUniform(Shader shader, Uniform uniform) {
        int uniformLoc = GL20.glGetUniformLocation((int)shader.getProgram().getID(), (CharSequence)uniform.getName());
        if (uniformLoc == -1) {
            LOGGER.trace("{}: Could not find uniform location for '{}'", (Object)shader.getClass().getSimpleName(), (Object)uniform.getName());
        }
        uniform.setLocation(uniformLoc);
    }

    public void addUniforms(Shader shader) {
        for (GLSLScript script : shader.getProgram().getScripts()) {
            for (Uniform u : script.getExpandedUniforms()) {
                LOGGER.trace("{}: uniform {} got added", (Object)this.getClass().getSimpleName(), (Object)u.getName());
                this.registerUniform(shader, u);
            }
        }
    }

    public void setUniform(Shader shader, Uniform uniform) {
        boolean primitive;
        if (!uniform.shouldSet()) {
            return;
        }
        boolean bl = primitive = uniform.getValue() instanceof Float || uniform.getValue() instanceof Integer || uniform.getValue() instanceof Double;
        if (!primitive && uniform.getValue() == null) {
            throw new IllegalStateException("Uniform value cannot be null for " + uniform);
        }
        if (uniform.getValue() instanceof Vector3f) {
            this.setUniform(shader, uniform.getName(), (Vector3f)uniform.getValue());
        } else if (uniform.getValue() instanceof Color) {
            this.setUniform(shader, uniform.getName(), (Color)uniform.getValue());
        } else if (uniform.getValue() instanceof Vector4f) {
            this.setUniform(shader, uniform.getName(), (Vector4f)uniform.getValue());
        } else if (uniform.getValue() instanceof Vector2f) {
            this.setUniform(shader, uniform.getName(), (Vector2f)uniform.getValue());
        } else if (uniform.getValue() instanceof Matrix4f) {
            this.setUniform(shader, uniform.getName(), (Matrix4f)uniform.getValue());
        } else if (uniform.getValue() instanceof Integer) {
            this.setUniform(shader, uniform.getName(), (Integer)uniform.getValue());
        } else if (uniform.getValue() instanceof Float) {
            this.setUniform(shader, uniform.getName(), ((Float)uniform.getValue()).floatValue());
        } else if (uniform.getValue() instanceof Double) {
            this.setUniform(shader, uniform.getName(), (Double)uniform.getValue());
        } else if (uniform.getValue() instanceof DirectionalLight) {
            this.setUniform(shader, uniform.getName(), (DirectionalLight)uniform.getValue());
        } else if (uniform.getValue() instanceof AmbientLight) {
            this.setUniform(shader, uniform.getName(), (AmbientLight)uniform.getValue());
        } else if (uniform.getValue() instanceof SpotLight) {
            this.setUniform(shader, uniform.getName(), (SpotLight)uniform.getValue());
        } else if (uniform.getValue() instanceof PointLight) {
            this.setUniform(shader, uniform.getName(), (PointLight)uniform.getValue());
        } else if (uniform.getValue() instanceof BaseLight) {
            this.setUniform(shader, uniform.getName(), (BaseLight)uniform.getValue());
        } else if (uniform.getValue() instanceof Attenuation) {
            this.setUniform(shader, uniform.getName(), (Attenuation)uniform.getValue());
        } else if (uniform.getValue() instanceof Fog) {
            this.setUniform(shader, uniform.getName(), (Fog)uniform.getValue());
        } else {
            Uniform.SetStrategy strategy = uniform.getSetStrategy();
            if (strategy == null) {
                throw new UnsupportedOperationException("Cannot set uniform and no SetStrategy provided");
            }
            strategy.set(uniform, this);
        }
    }

    public void setUniform(Shader shader, String name, Vector3f vec) {
        GL20.glUniform3f((int)shader.getProgram().getExpandedUniform(name).getLocation(), (float)vec.getX(), (float)vec.getY(), (float)vec.getZ());
    }

    public void setUniform(Shader shader, String name, Vector4f vec) {
        GL20.glUniform4f((int)shader.getProgram().getExpandedUniform(name).getLocation(), (float)vec.getX(), (float)vec.getY(), (float)vec.getZ(), (float)vec.getW());
    }

    public void setUniform(Shader shader, String name, Color color) {
        this.setUniform(shader, name, (Vector4f)color);
    }

    public void setUniform(Shader shader, String name, Vector2f vec) {
        GL20.glUniform2f((int)shader.getProgram().getExpandedUniform(name).getLocation(), (float)vec.getX(), (float)vec.getY());
    }

    public void setUniform(Shader shader, String name, Matrix4f matrix) {
        GL20.glUniformMatrix4((int)shader.getProgram().getExpandedUniform(name).getLocation(), (boolean)true, (FloatBuffer)((FloatBuffer)UBuffer.create(matrix).flip()));
    }

    public void setUniform(Shader shader, String name, int value) {
        GL20.glUniform1i((int)shader.getProgram().getExpandedUniform(name).getLocation(), (int)value);
    }

    public void setUniform(Shader shader, String name, float value) {
        GL20.glUniform1f((int)shader.getProgram().getExpandedUniform(name).getLocation(), (float)value);
    }

    public void setUniform(Shader shader, String name, double value) {
        this.setUniform(shader, name, (float)value);
    }

    public void setUniform(Shader shader, String name, Fog fog) {
        this.setUniform(shader, name + ".mode", fog.getMode().getID());
        if (fog.getMode().equals((Object)Fog.Mode.DISABLED)) {
            return;
        }
        this.setUniform(shader, name + ".color", fog.getColor());
        if (fog.getMode().equals((Object)Fog.Mode.LINEAR)) {
            this.setUniform(shader, name + ".start", fog.getRange().getX());
            this.setUniform(shader, name + ".end", fog.getRange().getY());
        } else {
            this.setUniform(shader, name + ".density", fog.getDensity());
        }
    }

    public void setUniform(Shader shader, String name, DirectionalLight directionalLight) {
        this.setUniform(shader, name + ".base", (BaseLight)directionalLight);
        this.setUniform(shader, name + ".direction", directionalLight.getDirection());
    }

    public void setUniform(Shader shader, String name, AmbientLight ambientLight) {
        this.setUniform(shader, name + ".color", ambientLight.getColor());
    }

    public void setUniform(Shader shader, String name, BaseLight baseLight) {
        this.setUniform(shader, name + ".color", baseLight.getColor().getColor());
        this.setUniform(shader, name + ".intensity", baseLight.getIntensity());
    }

    public void setUniform(Shader shader, String name, PointLight pointLight) {
        this.setUniform(shader, name + ".base", (BaseLight)pointLight);
        this.setUniform(shader, name + ".attenuation", pointLight.getAttenuation());
        this.setUniform(shader, name + ".position", pointLight.getTransform().getTransformedPosition());
        this.setUniform(shader, name + ".range", pointLight.getRange());
    }

    public void setUniform(Shader shader, String name, Attenuation attenuation) {
        this.setUniform(shader, name + ".constant", attenuation.getConstant());
        this.setUniform(shader, name + ".linear", attenuation.getLinear());
        this.setUniform(shader, name + ".exponent", attenuation.getExponent());
    }

    public void setUniform(Shader shader, String name, SpotLight spotLight) {
        this.setUniform(shader, name + ".pointLight", (PointLight)spotLight);
        this.setUniform(shader, name + ".direction", spotLight.getDirection());
        this.setUniform(shader, name + ".cutoff", spotLight.getCutoff());
    }
}

