/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.EngineHolder;
import org.achtern.AchternEngine.core.Game;
import org.achtern.AchternEngine.core.LoadingScreen;
import org.achtern.AchternEngine.core.Time;
import org.achtern.AchternEngine.core.Window;
import org.achtern.AchternEngine.core.bootstrap.BindingProvider;
import org.achtern.AchternEngine.core.bootstrap.BuildInfo;
import org.achtern.AchternEngine.core.bootstrap.CommonDrawStrategyFactoryPopulator;
import org.achtern.AchternEngine.core.rendering.BasicRenderEngine;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.util.FPS;
import org.achtern.AchternEngine.core.util.WindowChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreEngine
implements Runnable,
EngineHolder<RenderEngine> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CoreEngine.class);
    protected BindingProvider bindingProvider;
    protected Window window;
    protected List<WindowChangeListener> windowChangeListenerList;
    private boolean stopRequest = false;
    private boolean running;
    private Game game;
    private RenderEngine renderEngine;
    private double frameTime;
    private FPS fps;

    public void requestStop() {
        this.stopRequest = true;
    }

    public boolean stopRequested() {
        return this.stopRequest;
    }

    public CoreEngine(Game game, BindingProvider binding) {
        LOGGER.debug(BuildInfo.get());
        this.game = game;
        this.running = false;
        this.fps = new FPS();
        this.bindingProvider = binding;
        this.windowChangeListenerList = new ArrayList<WindowChangeListener>();
        this.bindingProvider.getGraphicsBindingProvider().populateDrawStrategyFactory();
        CommonDrawStrategyFactoryPopulator.populate();
    }

    protected void createWindow(String title, Dimension dimensions) {
        this.window = this.bindingProvider.getGraphicsBindingProvider().getWindow(dimensions);
        this.window.create(title);
        this.renderEngine = new BasicRenderEngine(this.bindingProvider.getGraphicsBindingProvider());
        LOGGER.debug("OpenGL Version: {}", (Object)this.renderEngine.getState().getVersion());
    }

    public void start(double framerate) {
        this.frameTime = 1.0 / framerate;
        if (this.running) {
            return;
        }
        this.run();
    }

    protected void stop() {
        if (!this.running) {
            throw new IllegalStateException("Engine is already stopped.");
        }
        this.running = false;
    }

    @Override
    public void run() {
        this.running = true;
        this.createWindow(this.game.getWindowTitle(), this.game.getWindowDimensions());
        try {
            Texture loadingScreen = this.game.getSplashScreen();
            if (loadingScreen != null) {
                LoadingScreen.get().show(this, loadingScreen);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error loading loading screen, ignoring", (Throwable)e);
        }
        LOGGER.info("Initializing Game");
        this.game.preInit(this);
        LOGGER.info("Done initializing Game");
        double lastTime = Time.getTime();
        double unprocessedTime = 0.0;
        while (this.running) {
            boolean render = false;
            double startTime = Time.getTime();
            double passedTime = startTime - lastTime;
            lastTime = startTime;
            unprocessedTime += passedTime;
            this.fps.passed(passedTime);
            while (unprocessedTime > this.frameTime) {
                render = true;
                unprocessedTime -= this.frameTime;
                if (this.window.isCloseRequested() || this.stopRequested()) {
                    this.stop();
                }
                this.game.updateSceneGraph((float)this.frameTime);
                this.game.getInputManager().trigger((float)this.frameTime);
                this.fps.display();
            }
            if (render) {
                this.game.renderSceneGraph(this.renderEngine);
                this.window.render();
                this.fps.rendered();
            }
            if (!this.window.resized()) continue;
            for (WindowChangeListener l : this.windowChangeListenerList) {
                l.onWindowChange(this.window);
            }
        }
        this.cleanUp();
    }

    public void cleanUp() {
        this.window.dispose();
        LOGGER.info("Shutdown.");
    }

    public void addWindowChangeListener(WindowChangeListener listener) {
        this.windowChangeListenerList.add(listener);
    }

    public void removeWindowChangeListener(WindowChangeListener listener) {
        this.windowChangeListenerList.remove(listener);
    }

    public FPS getFps() {
        return this.fps;
    }

    public RenderEngine getRenderEngine() {
        return this.getEngine();
    }

    @Override
    public void setEngine(RenderEngine engine) {
        this.renderEngine = engine;
    }

    @Override
    public RenderEngine getEngine() {
        return this.renderEngine;
    }

    public Game getGame() {
        return this.game;
    }

    public Window getWindow() {
        return this.window;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }
}

