/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core;

import org.achtern.AchternEngine.core.CoreEngine;
import org.achtern.AchternEngine.core.EngineHolder;
import org.achtern.AchternEngine.core.GameDebugger;
import org.achtern.AchternEngine.core.input.InputManager;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.Renderable;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.Updatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Game
implements Updatable,
Renderable,
EngineHolder<CoreEngine> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Game.class);
    private Node mainNode;
    private CoreEngine engine;
    private GameDebugger debugger;
    private InputManager inputManager;

    public abstract Dimension getWindowDimensions();

    public String getWindowTitle() {
        return this.getClass().getSimpleName();
    }

    public void updateSceneGraph(float delta) {
        if (this.isDebug()) {
            this.debugger.update(delta);
        }
        this.getSceneGraph().update(delta);
        this.update(delta);
    }

    public final void preInit(CoreEngine engine) {
        this.setEngine(engine);
        this.setInputManager(new InputManager(engine.getBindingProvider().getGraphicsBindingProvider().getInputAdapter()));
        this.getSceneGraph().setEngine(engine);
        this.init(engine);
    }

    public abstract void init(CoreEngine var1);

    public final void renderSceneGraph(RenderEngine renderEngine) {
        this.preRender(renderEngine);
        LOGGER.trace("Rendering SceneGraph: {}", (Object)this.getSceneGraph());
        renderEngine.render(this.getSceneGraph());
        this.render(renderEngine);
    }

    public void preRender(RenderEngine renderEngine) {
    }

    public void add(Node node) {
        this.getSceneGraph().add(node);
        LOGGER.trace("Node added to scene graph: {}", (Object)node);
    }

    public void add(Node node, boolean forceName) {
        this.getSceneGraph().add(node, forceName);
        LOGGER.trace("Node added to scene graph: {}", (Object)node);
    }

    public Node get(String nodeName) {
        Node r;
        if (nodeName.contains("/")) {
            String[] nodes = nodeName.split("/");
            r = this.getSceneGraph().getChildren().get(nodes[0]);
            if (r == null) {
                return null;
            }
            for (int i = 1; i < nodes.length; ++i) {
                String name = nodes[i];
                r = r.getChildren().get(name);
            }
        } else {
            r = this.getSceneGraph().getChildren().get(nodeName);
        }
        return r;
    }

    public boolean has(Node node) {
        return this.getSceneGraph().getChildren().containsValue(node);
    }

    public void remove(Node node) {
        if (!this.has(node)) {
            throw new IllegalStateException("Node doesn' t exists");
        }
        this.getSceneGraph().remove(node);
    }

    public boolean remove(String nodeName) {
        Node toBeRemoved = this.getSceneGraph().getChildren().get(nodeName);
        return toBeRemoved != null && this.getSceneGraph().remove(toBeRemoved);
    }

    public int numberOfEntities() {
        return this.getSceneGraph().numberOfEntities();
    }

    private Node getSceneGraph() {
        if (this.mainNode == null) {
            LOGGER.debug("Scene Graph created");
            this.mainNode = new Node("Scene Graph");
            this.mainNode.setEngine(this.getEngine());
        }
        return this.mainNode;
    }

    public Texture getSplashScreen() throws Exception {
        return ResourceLoader.getTexture("loading.v0.0.1.png");
    }

    @Override
    public CoreEngine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(CoreEngine engine) {
        this.engine = engine;
    }

    public boolean isDebug() {
        return this.debugger != null;
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.debugger = new GameDebugger(this);
            this.debugger.setEngine(this.getEngine());
            this.debugger.enable();
        } else if (this.debugger != null) {
            this.debugger.disable();
            this.debugger = null;
        }
    }

    public GameDebugger getDebugger() {
        return this.debugger;
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    public void setInputManager(InputManager inputManager) {
        this.inputManager = inputManager;
    }
}

