/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core;

import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Quaternion;
import org.achtern.AchternEngine.core.math.Vector3f;

public class Transform {
    public static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f).lock();
    public static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f).lock();
    public static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f).lock();
    private Transform parent;
    private Matrix4f parentMat;
    private Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    private Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public Transform() {
        this.parentMat = new Matrix4f().initIdentiy();
    }

    public Matrix4f getTransformation() {
        Matrix4f positionMat = new Matrix4f().initTranslation(this.position.getX(), this.position.getY(), this.position.getZ());
        Matrix4f rotationMat = this.rotation.toRotationMatrix();
        Matrix4f scaleMat = new Matrix4f().initScale(this.scale.getX(), this.scale.getY(), this.scale.getZ());
        return this.getParentMatrix().mul(positionMat.mul(rotationMat.mul(scaleMat)));
    }

    public void rotate(Vector3f axis, float angle) {
        this.setRotation(new Quaternion().initRotation(axis, (float)Math.toRadians(angle)).mul(this.getRotation()).normalized());
    }

    public void faceAt(Vector3f at, Vector3f up) {
        this.getRotation().faceAt(at, up);
    }

    public Quaternion getFaceAt(Vector3f at, Vector3f up) {
        return new Quaternion(new Matrix4f().initRotation(at.sub(this.getPosition()).normalized(), up));
    }

    public Vector3f getTransformedPosition() {
        return this.getParentMatrix().transform(this.getPosition());
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public Quaternion getTransformedRotation() {
        Quaternion parent = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.parent != null) {
            parent = this.parent.getTransformedRotation();
        }
        return parent.mul(this.getRotation());
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public void setParent(Transform parent) {
        this.parent = parent;
    }

    private Matrix4f getParentMatrix() {
        if (this.parent != null) {
            this.parentMat = this.parent.getTransformation();
        }
        return this.parentMat;
    }

    public Transform apply(Transform transform) {
        this.setPosition(transform.getTransformedPosition());
        this.setRotation(transform.getTransformedRotation());
        this.setScale(transform.getScale());
        return this;
    }
}

