/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.audio.openal;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import org.achtern.AchternEngine.core.audio.openal.Format;
import org.achtern.AchternEngine.core.bootstrap.NativeObject;

public class AudioBuffer
extends NativeObject {
    protected ByteBuffer data;
    protected int frequency;
    protected Format format;

    public static int getSampleSize(int bits, int channels) {
        return bits / 8 * channels;
    }

    public float getLengthInSamples() {
        int size = this.data.capacity();
        int channels = this.format.isStereo() ? 2 : 1;
        int bits = this.format.getBits();
        return size / AudioBuffer.getSampleSize(bits, channels);
    }

    public float getLengthInSeconds() {
        return this.getLengthInSamples() / (float)this.getFrequency();
    }

    public String toString() {
        return "AudioBuffer{data=" + this.data + ", frequency=" + this.frequency + ", format=" + (Object)((Object)this.format) + ", length=" + this.getLengthInSeconds() + "sec" + '}';
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public Format getFormat() {
        return this.format;
    }

    @ConstructorProperties(value={"data", "frequency", "format"})
    public AudioBuffer(ByteBuffer data, int frequency, Format format) {
        this.data = data;
        this.frequency = frequency;
        this.format = format;
    }
}

